/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class StoredProcedureIndex
implements SearchIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final StoredProcedure storedProcedure;

    public StoredProcedureIndex(StoredProcedure storedProcedure) {
        this.storedProcedure = storedProcedure;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.storedProcedure);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.storedProcedure.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "storedProcedure");
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("storedProcedure", (EntityInterface)this.storedProcedure));
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        if (this.storedProcedure.getOwner() != null) {
            doc.put("owner", this.getOwnerWithDisplayName(this.storedProcedure.getOwner()));
        }
        if (this.storedProcedure.getDomain() != null) {
            doc.put("domain", this.getDomainWithDisplayName(this.storedProcedure.getDomain()));
        }
        return doc;
    }

    public static Map<String, Float> getFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(15.0f));
        fields.put("name", Float.valueOf(15.0f));
        fields.put("displayName.keyword", Float.valueOf(25.0f));
        fields.put("name.keyword", Float.valueOf(25.0f));
        fields.put("description", Float.valueOf(1.0f));
        fields.put("fqnParts.keyword", Float.valueOf(10.0f));
        return fields;
    }
}

