/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets;

import java.util.Locale;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.service.secrets.SecretsManager;

public abstract class ExternalSecretsManager
extends SecretsManager {
    public static final String NULL_SECRET_STRING = "null";
    public static final String SECRET_FIELD_PREFIX = "secret:";
    private final long waitTimeBetweenStoreCalls;

    protected ExternalSecretsManager(SecretsManagerProvider secretsManagerProvider, String clusterPrefix, long waitTimeBetweenCalls) {
        super(secretsManagerProvider, clusterPrefix);
        this.waitTimeBetweenStoreCalls = waitTimeBetweenCalls;
    }

    @Override
    protected String storeValue(String fieldName, String value, String secretId, boolean store) {
        String fieldSecretId = this.buildSecretId(false, secretId, fieldName.toLowerCase(Locale.ROOT));
        if (!value.startsWith(SECRET_FIELD_PREFIX)) {
            if (store) {
                this.upsertSecret(fieldSecretId, value);
            }
            return SECRET_FIELD_PREFIX + fieldSecretId;
        }
        return value;
    }

    public void upsertSecret(String secretName, String secretValue) {
        if (this.existSecret(secretName)) {
            this.updateSecret(secretName, secretValue != null ? secretValue : NULL_SECRET_STRING);
            this.sleep();
        } else {
            this.storeSecret(secretName, secretValue != null ? secretValue : NULL_SECRET_STRING);
            this.sleep();
        }
    }

    public boolean existSecret(String secretName) {
        try {
            boolean exists = this.getSecret(secretName) != null;
            this.sleep();
            return exists;
        }
        catch (Exception e) {
            return false;
        }
    }

    abstract void storeSecret(String var1, String var2);

    abstract void updateSecret(String var1, String var2);

    abstract String getSecret(String var1);

    private void sleep() {
        if (this.waitTimeBetweenStoreCalls > 0L) {
            try {
                Thread.sleep(this.waitTimeBetweenStoreCalls);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

