/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.security.client.Auth0SSOClientConfig;
import org.openmetadata.schema.security.client.AzureSSOClientConfig;
import org.openmetadata.schema.security.client.CustomOIDCSSOClientConfig;
import org.openmetadata.schema.security.client.GoogleSSOClientConfig;
import org.openmetadata.schema.security.client.OktaSSOClientConfig;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.util.JsonUtils;

public class SSOAuthMechanismClassConverter
extends ClassConverter {
    private static final List<Class<?>> AUTH_CONFIG_CLASSES = List.of(GoogleSSOClientConfig.class, OktaSSOClientConfig.class, Auth0SSOClientConfig.class, CustomOIDCSSOClientConfig.class, AzureSSOClientConfig.class);

    public SSOAuthMechanismClassConverter() {
        super(SSOAuthMechanism.class);
    }

    @Override
    public Object convert(Object object) {
        SSOAuthMechanism ssoAuthMechanism = (SSOAuthMechanism)JsonUtils.convertValue(object, this.clazz);
        this.tryToConvertOrFail(ssoAuthMechanism.getAuthConfig(), AUTH_CONFIG_CLASSES).ifPresent(arg_0 -> ((SSOAuthMechanism)ssoAuthMechanism).setAuthConfig(arg_0));
        return ssoAuthMechanism;
    }
}

