/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.PercentageOfServicesWithOwner;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class ServicesOwnerAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    protected final A aggregations;

    public ServicesOwnerAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M serviceBuckets = this.getServiceBuckets(timestampBucket);
            for (B serviceBucket : this.getBuckets(serviceBuckets)) {
                String serviceName = this.getKeyAsString(serviceBucket);
                S sumHasOwner = this.getSumAggregations(serviceBucket, "hasOwnerFraction");
                S sumEntityCount = this.getSumAggregations(serviceBucket, "entityCount");
                data.add(new PercentageOfServicesWithOwner().withTimestamp(timestamp).withServiceName(serviceName).withEntityCount(this.getValue(sumEntityCount)).withHasOwner(this.getValue(sumHasOwner)).withHasOwnerFraction(Double.valueOf(this.getValue(sumHasOwner) / this.getValue(sumEntityCount))));
            }
        }
        return data;
    }

    protected abstract Double getValue(S var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract M getServiceBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

