/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.exception;

import com.google.common.collect.Iterables;
import io.dropwizard.jersey.errors.ErrorMessage;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    public Response toResponse(ConstraintViolationException exception) {
        Set constraintViolations = exception.getConstraintViolations();
        List<String> errorMessages = constraintViolations.stream().map(constraintViolation -> {
            String name = ((Path.Node)Iterables.getLast((Iterable)constraintViolation.getPropertyPath())).getName();
            return name + " " + constraintViolation.getMessage();
        }).toList();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), errorMessages.toString())).build();
    }
}

