/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class DashboardRepository
extends EntityRepository<Dashboard> {
    private static final String DASHBOARD_UPDATE_FIELDS = "charts,dataModels";
    private static final String DASHBOARD_PATCH_FIELDS = "charts,dataModels,sourceHash";
    private static final String DASHBOARD_URL = "sourceUrl";

    public DashboardRepository() {
        super("v1/dashboards/", "dashboard", Dashboard.class, Entity.getCollectionDAO().dashboardDAO(), DASHBOARD_PATCH_FIELDS, DASHBOARD_UPDATE_FIELDS);
        this.supportsSearch = true;
    }

    @Override
    public void setFullyQualifiedName(Dashboard dashboard) {
        dashboard.setFullyQualifiedName(FullyQualifiedName.add(dashboard.getService().getFullyQualifiedName(), dashboard.getName()));
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals("charts")) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (entityLink.getArrayFieldValue() != null) {
                return new ChartDescriptionAndTagTaskWorkflow(threadContext);
            }
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidFieldForTask(entityLink.getFieldName(), taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    @Override
    public Dashboard setFields(Dashboard dashboard, EntityUtil.Fields fields) {
        dashboard.setService(this.getContainer(dashboard.getId()));
        dashboard.setCharts(fields.contains("charts") ? this.getRelatedEntities(dashboard, "chart") : null);
        dashboard.setDataModels(fields.contains("dataModels") ? this.getRelatedEntities(dashboard, "dashboardDataModel") : null);
        dashboard.setSourceHash(fields.contains("sourceHash") ? dashboard.getSourceHash() : null);
        if (dashboard.getUsageSummary() == null) {
            dashboard.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), dashboard.getId()) : null);
        }
        return dashboard;
    }

    @Override
    public Dashboard clearFields(Dashboard dashboard, EntityUtil.Fields fields) {
        dashboard.setCharts(fields.contains("charts") ? dashboard.getCharts() : null);
        dashboard.setDataModels(fields.contains("dataModels") ? dashboard.getDataModels() : null);
        return dashboard.withUsageSummary(fields.contains("usageSummary") ? dashboard.getUsageSummary() : null);
    }

    @Override
    public void restorePatchAttributes(Dashboard original, Dashboard updated) {
        updated.withId(original.getId()).withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService());
    }

    private void populateService(Dashboard dashboard) {
        DashboardService service = (DashboardService)Entity.getEntity(dashboard.getService(), "", Include.NON_DELETED);
        dashboard.setService(service.getEntityReference());
        dashboard.setServiceType(service.getServiceType());
    }

    public void setService(Dashboard dashboard, EntityReference service) {
        if (service != null && dashboard != null) {
            this.addRelationship(service.getId(), dashboard.getId(), service.getType(), "dashboard", Relationship.CONTAINS);
            dashboard.setService(service);
        }
    }

    @Override
    public void prepare(Dashboard dashboard, boolean update) {
        this.populateService(dashboard);
        dashboard.setCharts(EntityUtil.getEntityReferences(dashboard.getCharts(), Include.NON_DELETED));
        dashboard.setDataModels(EntityUtil.getEntityReferences(dashboard.getDataModels(), Include.NON_DELETED));
    }

    @Override
    public void storeEntity(Dashboard dashboard, boolean update) {
        EntityReference service = dashboard.getService();
        List charts = dashboard.getCharts();
        List dataModels = dashboard.getDataModels();
        dashboard.withService(null).withCharts(null).withDataModels(null);
        this.store(dashboard, update);
        dashboard.withService(service).withCharts(charts).withDataModels(dataModels);
    }

    @Override
    public void storeRelationships(Dashboard dashboard) {
        this.setService(dashboard, dashboard.getService());
        if (dashboard.getCharts() != null) {
            for (EntityReference chart : dashboard.getCharts()) {
                this.addRelationship(dashboard.getId(), chart.getId(), "dashboard", "chart", Relationship.HAS);
            }
        }
        if (dashboard.getDataModels() != null) {
            for (EntityReference dataModel : dashboard.getDataModels()) {
                this.addRelationship(dashboard.getId(), dataModel.getId(), "dashboard", "dashboardDataModel", Relationship.HAS);
            }
        }
    }

    @Override
    public Dashboard setInheritedFields(Dashboard dashboard, EntityUtil.Fields fields) {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(dashboard.getService(), "domain", Include.ALL);
        return this.inheritDomain(dashboard, fields, (EntityInterface)dashboardService);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Dashboard original, Dashboard updated, EntityRepository.Operation operation) {
        return new DashboardUpdater(original, updated, operation);
    }

    @Override
    public EntityInterface getParentEntity(Dashboard entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.ALL);
    }

    private List<EntityReference> getRelatedEntities(Dashboard dashboard, String entityType) {
        return dashboard == null ? Collections.emptyList() : this.findTo(dashboard.getId(), "dashboard", Relationship.HAS, entityType);
    }

    static class ChartDescriptionAndTagTaskWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        ChartDescriptionAndTagTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            MessageParser.EntityLink entityLink = threadContext.getAbout();
            Dashboard dashboard = (Dashboard)Entity.getEntity("dashboard", threadContext.getAboutEntity().getId(), "charts", Include.ALL);
            String chartName = threadContext.getAbout().getArrayFieldName();
            EntityReference chartReference = dashboard.getCharts().stream().filter(c -> c.getName().equals(chartName)).findFirst().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("chart", chartName)));
            Chart chart = (Chart)Entity.getEntity(chartReference, "", Include.ALL);
            if (entityLink.getArrayFieldValue().equals("description")) {
                threadContext.setAbout(new MessageParser.EntityLink("chart", chart.getFullyQualifiedName(), "description", null, null));
            } else if (entityLink.getArrayFieldValue().equals("tags")) {
                threadContext.setAbout(new MessageParser.EntityLink("chart", chart.getFullyQualifiedName(), "tags", null, null));
            }
            threadContext.setAboutEntity((EntityInterface)chart);
        }
    }

    public class DashboardUpdater
    extends EntityRepository.EntityUpdater {
        public DashboardUpdater(Dashboard original, Dashboard updated, EntityRepository.Operation operation) {
            super((EntityRepository)DashboardRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.update("chart", "charts", CommonUtil.listOrEmpty((List)((Dashboard)this.updated).getCharts()), CommonUtil.listOrEmpty((List)((Dashboard)this.original).getCharts()));
            this.update("dashboardDataModel", "dataModels", CommonUtil.listOrEmpty((List)((Dashboard)this.updated).getDataModels()), CommonUtil.listOrEmpty((List)((Dashboard)this.original).getDataModels()));
            this.updateDashboardUrl((Dashboard)this.original, (Dashboard)this.updated);
            this.recordChange("sourceHash", ((Dashboard)this.original).getSourceHash(), ((Dashboard)this.updated).getSourceHash());
        }

        private void update(String entityType, String field, List<EntityReference> updEntities, List<EntityReference> oriEntities) {
            DashboardRepository.this.deleteFrom(((Dashboard)this.updated).getId(), "dashboard", Relationship.HAS, entityType);
            for (EntityReference entity : updEntities) {
                DashboardRepository.this.addRelationship(((Dashboard)this.updated).getId(), entity.getId(), "dashboard", entityType, Relationship.HAS);
            }
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange(field, oriEntities, updEntities, added, deleted, EntityUtil.entityReferenceMatch);
        }

        public void updateDashboardUrl(Dashboard original, Dashboard updated) {
            this.recordChange(DashboardRepository.DASHBOARD_URL, original.getSourceUrl(), updated.getSourceUrl());
        }
    }
}

