/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.api.BulkAssets;
import org.openmetadata.schema.type.api.BulkOperationResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainRepository
extends EntityRepository<Domain> {
    private static final Logger LOG = LoggerFactory.getLogger(DomainRepository.class);
    private static final String UPDATE_FIELDS = "parent,children,experts";

    public DomainRepository() {
        super("/v1/domains/", "domain", Domain.class, Entity.getCollectionDAO().domainDAO(), UPDATE_FIELDS, UPDATE_FIELDS);
        this.supportsSearch = true;
    }

    @Override
    public Domain setFields(Domain entity, EntityUtil.Fields fields) {
        return entity.withParent(this.getParent(entity));
    }

    @Override
    public Domain clearFields(Domain entity, EntityUtil.Fields fields) {
        entity.withParent(fields.contains("parent") ? entity.getParent() : null);
        return entity;
    }

    @Override
    public void prepare(Domain entity, boolean update) {
    }

    @Override
    public void storeEntity(Domain entity, boolean update) {
        EntityReference parent = entity.getParent();
        entity.withParent(null);
        this.store(entity, update);
        entity.withParent(parent);
    }

    @Override
    public void storeRelationships(Domain entity) {
        if (entity.getParent() != null) {
            this.addRelationship(entity.getParent().getId(), entity.getId(), "domain", "domain", Relationship.CONTAINS);
        }
        for (EntityReference expert : CommonUtil.listOrEmpty((List)entity.getExperts())) {
            this.addRelationship(entity.getId(), expert.getId(), "domain", "user", Relationship.EXPERT);
        }
    }

    @Override
    public Domain setInheritedFields(Domain domain, EntityUtil.Fields fields) {
        EntityReference parentRef;
        EntityReference entityReference = parentRef = domain.getParent() != null ? domain.getParent() : this.getParent(domain);
        if (parentRef != null) {
            Domain parent = (Domain)Entity.getEntity("domain", parentRef.getId(), "owner,experts", Include.ALL);
            this.inheritOwner(domain, fields, (EntityInterface)parent);
            this.inheritExperts(domain, fields, (EntityInterface)parent);
        }
        return domain;
    }

    public BulkOperationResult bulkAddAssets(String domainName, BulkAssets request) {
        Domain domain = (Domain)this.getByName(null, domainName, this.getFields("id"));
        return this.bulkAssetsOperation(domain.getId(), "domain", Relationship.HAS, request, true);
    }

    public BulkOperationResult bulkRemoveAssets(String domainName, BulkAssets request) {
        Domain domain = (Domain)this.getByName(null, domainName, this.getFields("id"));
        return this.bulkAssetsOperation(domain.getId(), "domain", Relationship.HAS, request, false);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Domain original, Domain updated, EntityRepository.Operation operation) {
        return new DomainUpdater(original, updated, operation);
    }

    @Override
    public void restorePatchAttributes(Domain original, Domain updated) {
        updated.withParent(original.getParent());
        updated.withChildren(original.getChildren());
    }

    @Override
    public void setFullyQualifiedName(Domain entity) {
        if (entity.getParent() == null) {
            entity.setFullyQualifiedName(FullyQualifiedName.build(entity.getName()));
        } else {
            EntityReference parent = entity.getParent();
            entity.setFullyQualifiedName(FullyQualifiedName.add(parent.getFullyQualifiedName(), entity.getName()));
        }
    }

    @Override
    public EntityInterface getParentEntity(Domain entity, String fields) {
        return entity.getParent() != null ? (EntityInterface)Entity.getEntity(entity.getParent(), fields, Include.NON_DELETED) : null;
    }

    public class DomainUpdater
    extends EntityRepository.EntityUpdater {
        public DomainUpdater(Domain original, Domain updated, EntityRepository.Operation operation) {
            super((EntityRepository)DomainRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange("domainType", ((Domain)this.original).getDomainType(), ((Domain)this.updated).getDomainType());
        }
    }
}

