/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources;

import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.setup.Environment;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import io.swagger.annotations.Api;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Path;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.schema.Function;
import org.openmetadata.schema.type.CollectionDescriptor;
import org.openmetadata.schema.type.CollectionInfo;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.auth.AuthenticatorHandler;
import org.openmetadata.service.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionRegistry.class);
    private static CollectionRegistry instance = null;
    private static volatile boolean initialized = false;
    private final Map<String, CollectionDetails> collectionMap = new LinkedHashMap<String, CollectionDetails>();
    private final Map<Class<?>, List<org.openmetadata.schema.type.Function>> functionMap = new ConcurrentHashMap();
    @VisibleForTesting
    private final List<Object> testResources = new ArrayList<Object>();

    private CollectionRegistry() {
    }

    public static CollectionRegistry getInstance() {
        if (!initialized) {
            CollectionRegistry.initialize();
        }
        return instance;
    }

    public List<org.openmetadata.schema.type.Function> getFunctions(Class<?> clz) {
        return this.functionMap.get(clz);
    }

    public static void initialize() {
        if (!initialized) {
            instance = new CollectionRegistry();
            initialized = true;
            instance.loadCollectionDescriptors();
            instance.loadConditionFunctions();
        } else {
            LOG.info("[Collection Registry] is already initialized.");
        }
    }

    public Map<String, CollectionDetails> getCollectionMap() {
        return Collections.unmodifiableMap(this.collectionMap);
    }

    private void loadCollectionDescriptors() {
        List<CollectionDetails> collections = CollectionRegistry.getCollections();
        for (int i = 0; i < 10; ++i) {
            for (CollectionDetails collection : collections) {
                if (collection.order != i) continue;
                CollectionInfo collectionInfo = collection.cd.getCollection();
                this.collectionMap.put(collectionInfo.getHref().getPath(), collection);
            }
        }
    }

    private void loadConditionFunctions() {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithMethodAnnotation(Function.class)) {
                List<Method> methods = ClassUtil.getMethodsAnnotatedWith(classInfo.loadClass(), Function.class);
                for (Method method : methods) {
                    Function annotation = method.getAnnotation(Function.class);
                    List functionList = this.functionMap.computeIfAbsent(method.getDeclaringClass(), k -> new ArrayList());
                    org.openmetadata.schema.type.Function function = new org.openmetadata.schema.type.Function().withName(annotation.name()).withInput(annotation.input()).withDescription(annotation.description()).withExamples(List.of(annotation.examples())).withParameterInputType(annotation.paramInputType());
                    functionList.add(function);
                    functionList.sort(Comparator.comparing(org.openmetadata.schema.type.Function::getName));
                    LOG.info("Initialized for {} function {}\n", (Object)method.getDeclaringClass().getSimpleName(), (Object)function);
                }
            }
        }
    }

    @VisibleForTesting
    public static void addTestResource(Object testResource) {
        CollectionRegistry.getInstance().testResources.add(testResource);
    }

    public void registerResources(Jdbi jdbi, Environment environment, OpenMetadataApplicationConfig config, Authorizer authorizer, AuthenticatorHandler authenticatorHandler) {
        for (Map.Entry<String, CollectionDetails> e : this.collectionMap.entrySet()) {
            CollectionDetails details = e.getValue();
            String resourceClass = details.resourceClass;
            try {
                Object resource = CollectionRegistry.createResource(jdbi, resourceClass, config, authorizer, authenticatorHandler);
                details.setResource(resource);
                environment.jersey().register(resource);
                LOG.info("Registering {} with order {}", (Object)resourceClass, (Object)details.order);
            }
            catch (Exception ex) {
                LOG.warn("Failed to create resource for class {} {}", (Object)resourceClass, (Object)ex);
            }
        }
        this.testResources.forEach(object -> {
            LOG.info("Registering test resource {}", object);
            environment.jersey().register(object);
        });
    }

    private static CollectionDetails getCollection(Class<?> cl) {
        int order = 0;
        CollectionInfo collectionInfo = new CollectionInfo();
        for (Annotation a : cl.getAnnotations()) {
            if (a instanceof Path) {
                collectionInfo.withHref(URI.create(((Path)a).value()));
                continue;
            }
            if (a instanceof Api) {
                collectionInfo.withDocumentation(((Api)a).value());
                continue;
            }
            if (!(a instanceof Collection)) continue;
            Collection collection = (Collection)a;
            collectionInfo.withName(collection.name());
            order = collection.order();
        }
        CollectionDescriptor cd = new CollectionDescriptor();
        cd.setCollection(collectionInfo);
        return new CollectionDetails(cd, cl.getCanonicalName(), order);
    }

    private static List<CollectionDetails> getCollections() {
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().scan();){
            ClassInfoList classList = scanResult.getClassesWithAnnotation(Collection.class);
            List collectionClasses = classList.loadClasses();
            ArrayList<CollectionDetails> collections = new ArrayList<CollectionDetails>();
            for (Class cl : collectionClasses) {
                CollectionDetails cd = CollectionRegistry.getCollection(cl);
                collections.add(cd);
            }
            ArrayList<CollectionDetails> arrayList = collections;
            return arrayList;
        }
    }

    private static Object createResource(Jdbi jdbi, String resourceClass, OpenMetadataApplicationConfig config, Authorizer authorizer, AuthenticatorHandler authHandler) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object resource = null;
        Class<?> clz = Class.forName(resourceClass);
        try {
            resource = clz.getDeclaredConstructor(Authorizer.class).newInstance(authorizer);
        }
        catch (NoSuchMethodException e) {
            try {
                resource = clz.getDeclaredConstructor(Authorizer.class, AuthenticatorHandler.class).newInstance(authorizer, authHandler);
            }
            catch (NoSuchMethodException ex) {
                try {
                    resource = clz.getDeclaredConstructor(Jdbi.class, Authorizer.class).newInstance(jdbi, authorizer);
                }
                catch (NoSuchMethodException exe) {
                    resource = Class.forName(resourceClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception encountered while creating resource for {}", clz, (Object)ex);
        }
        try {
            Method initializeMethod = resource.getClass().getMethod("initialize", OpenMetadataApplicationConfig.class);
            initializeMethod.invoke(resource, new Object[]{config});
        }
        catch (NoSuchMethodException initializeMethod) {
        }
        catch (Exception ex) {
            LOG.warn("Encountered exception while initializing resource for {}", clz, (Object)ex);
        }
        try {
            Method upgradeMethod = resource.getClass().getMethod("upgrade", new Class[0]);
            upgradeMethod.invoke(resource, new Object[0]);
        }
        catch (NoSuchMethodException upgradeMethod) {
        }
        catch (Exception ex) {
            LOG.warn("Encountered exception ", (Throwable)ex);
        }
        return resource;
    }

    public static class CollectionDetails {
        private final String resourceClass;
        private Object resource;
        private final CollectionDescriptor cd;
        private final int order;

        CollectionDetails(CollectionDescriptor cd, String resourceClass, int order) {
            this.cd = cd;
            this.resourceClass = resourceClass;
            this.order = order;
        }

        public String getResourceClass() {
            return this.resourceClass;
        }

        public Object getResource() {
            return this.resource;
        }

        public void setResource(Object resource) {
            this.resource = resource;
        }
    }
}

