/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.datamodels;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreateDashboardDataModel;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.DashboardDataModelRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/dashboard/datamodels")
@Tag(name="Dashboard Data Models", description="`Data Models` are the schemas used to build dashboards, charts, or other data assets.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="datamodels")
public class DashboardDataModelResource
extends EntityResource<DashboardDataModel, DashboardDataModelRepository> {
    public static final String COLLECTION_PATH = "/v1/dashboard/datamodels";
    protected static final String FIELDS = "owner,tags,followers,domain,sourceHash";

    @Override
    public DashboardDataModel addHref(UriInfo uriInfo, DashboardDataModel dashboardDataModel) {
        super.addHref(uriInfo, dashboardDataModel);
        Entity.withHref(uriInfo, dashboardDataModel.getService());
        return dashboardDataModel;
    }

    public DashboardDataModelResource(Authorizer authorizer) {
        super("dashboardDataModel", authorizer);
    }

    @GET
    @Operation(operationId="listDashboardDataModels", summary="List Dashboard Data Models", description="Get a list of dashboard datamodels, optionally filtered by `service` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of dashboard datamodels", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardDataModelList.class))})})
    public ResultList<DashboardDataModel> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags,followers,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter dashboardDataModel by service name", schema=@Schema(type="string", example="superset")) @QueryParam(value="service") String serviceParam, @Parameter(description="Limit the number dashboardDataModel returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of dashboardDataModel before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of dashboardDataModel after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include).addQueryParam("service", serviceParam);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDataModelVersions", summary="List dashboard datamodel versions", description="Get a list of all the versions of a dashboard datamodel identified by `id`", responses={@ApiResponse(responseCode="200", description="List of dashboard datamodel versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard datamodel", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDataModelByID", summary="Get a dashboard datamodel by Id", description="Get a dashboard datamodel by `id`.", responses={@ApiResponse(responseCode="200", description="The dashboard datamodel", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardDataModel.class))}), @ApiResponse(responseCode="404", description="DataModel for instance {id} is not found")})
    public DashboardDataModel get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard datamodel", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags,followers,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (DashboardDataModel)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getDataModelByFQN", summary="Get a dashboard datamodel by fully qualified name", description="Get a dashboard datamodel by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="The dashboard datamodel", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardDataModel.class))}), @ApiResponse(responseCode="404", description="DataModel for instance {fqn} is not found")})
    public DashboardDataModel getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the dashboard datamodel", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tags,followers,domain,sourceHash")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (DashboardDataModel)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDataModelVersion", summary="Get a version of the dashboard datamodel", description="Get a version of the dashboard datamodel by given `id`", responses={@ApiResponse(responseCode="200", description="dashboard datamodel", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardDataModel.class))}), @ApiResponse(responseCode="404", description="DataModel for instance {id} and version {version} is not found")})
    public DashboardDataModel getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard datamodel", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="DataModel version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (DashboardDataModel)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createDataModel", summary="Create a dashboard datamodel", description="Create a dashboard datamodel under an existing `service`.", responses={@ApiResponse(responseCode="200", description="The dashboard datamodel", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardDataModel.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboardDataModel create) {
        DashboardDataModel dashboardDataModel = this.getDataModel(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, dashboardDataModel);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDataModel", summary="Update a dashboard datamodel", description="Update an existing dashboard datamodel using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the dashboard datamodel", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDataModel", summary="Create or update dashboard datamodel", description="Create a dashboard datamodel, it it does not exist or update an existing dashboard datamodel.", responses={@ApiResponse(responseCode="200", description="The updated dashboard datamodel", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardDataModel.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDashboardDataModel create) {
        DashboardDataModel dashboardDataModel = this.getDataModel(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, dashboardDataModel);
    }

    @PUT
    @Path(value="/{id}/followers")
    @Operation(operationId="addFollowerToDataModel", summary="Add a follower", description="Add a user identified by `userId` as followed of this data model", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DataModel for instance {id} is not found")})
    public Response addFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the data model", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user to be added as follower", schema=@Schema(type="UUID")) UUID userId) {
        return ((DashboardDataModelRepository)this.repository).addFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @DELETE
    @Path(value="/{id}/followers/{userId}")
    @Operation(operationId="deleteFollowerFromDataModel", summary="Remove a follower", description="Remove the user identified `userId` as a follower of the data model.")
    public Response deleteFollower(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the data model", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Id of the user being removed as follower", schema=@Schema(type="UUID")) @PathParam(value="userId") UUID userId) {
        return ((DashboardDataModelRepository)this.repository).deleteFollower(securityContext.getUserPrincipal().getName(), id, userId).toResponse();
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForEntity", summary="Update Vote for a Entity", description="Update vote for a Entity", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((DashboardDataModelRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDataModel", summary="Delete a data model by `id`.", description="Delete a dashboard datamodel by `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DataModel for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Id of the data model", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteDataModelByFQN", summary="Delete a data model by fully qualified name.", description="Delete a data model by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="DataModel for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @QueryParam(value="recursive") @DefaultValue(value="false") boolean recursive, @Parameter(description="Fully qualified name of the data model", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, recursive, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted data model.", description="Restore a soft deleted data model.", responses={@ApiResponse(responseCode="200", description="Successfully restored the data model", content={@Content(mediaType="application/json", schema=@Schema(implementation=DashboardDataModel.class))})})
    public Response restoreDataModel(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private DashboardDataModel getDataModel(CreateDashboardDataModel create, String user) {
        DatabaseUtil.validateColumns(create.getColumns());
        return ((DashboardDataModelRepository)this.repository).copy(new DashboardDataModel(), (CreateEntity)create, user).withService(EntityUtil.getEntityReference("dashboardService", create.getService())).withDataModelType(create.getDataModelType()).withSql(create.getSql()).withDataModelType(create.getDataModelType()).withServiceType(create.getServiceType()).withColumns(create.getColumns()).withProject(create.getProject()).withTags(create.getTags()).withSourceHash(create.getSourceHash());
    }

    public static class DashboardDataModelList
    extends ResultList<DashboardDataModel> {
    }
}

