/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import es.org.elasticsearch.action.bulk.BulkRequest;
import java.io.IOException;
import java.security.KeyStoreException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.util.SSLUtil;
import os.org.opensearch.action.bulk.BulkResponse;
import os.org.opensearch.client.RequestOptions;

public interface SearchClient {
    public static final String UPDATE = "update";
    public static final String ADD = "add";
    public static final String DELETE = "delete";
    public static final String GLOBAL_SEARCH_ALIAS = "all";
    public static final String DEFAULT_UPDATE_SCRIPT = "for (k in params.keySet()) { ctx._source.put(k, params.get(k)) }";
    public static final String REMOVE_DOMAINS_CHILDREN_SCRIPT = "ctx._source.remove('domain')";
    public static final String PROPAGATE_ENTITY_REFERENCE_FIELD_SCRIPT = "if(ctx._source.%s == null){ ctx._source.put('%s', params)}";
    public static final String PROPAGATE_FIELD_SCRIPT = "ctx._source.put('%s', '%s')";
    public static final String REMOVE_PROPAGATED_ENTITY_REFERENCE_FIELD_SCRIPT = "if((ctx._source.%s != null) && (ctx._source.%s.id == '%s')){ ctx._source.remove('%s')}";
    public static final String REMOVE_PROPAGATED_FIELD_SCRIPT = "ctx._source.remove('%s')";
    public static final String UPDATE_PROPAGATED_ENTITY_REFERENCE_FIELD_SCRIPT = "if((ctx._source.%s == null) || (ctx._source.%s.id == '%s')) { ctx._source.put('%s', params)}";
    public static final String SOFT_DELETE_RESTORE_SCRIPT = "ctx._source.put('deleted', '%s')";
    public static final String REMOVE_TAGS_CHILDREN_SCRIPT = "for (int i = 0; i < ctx._source.tags.length; i++) { if (ctx._source.tags[i].tagFQN == '%s') { ctx._source.tags.remove(i) }}";
    public static final String UPDATE_ADDED_DELETE_GLOSSARY_TAGS = "if (ctx._source.tags != null) { for (int i = ctx._source.tags.size() - 1; i >= 0; i--) { if (params.tagDeleted != null) { for (int j = 0; j < params.tagDeleted.size(); j++) { if (ctx._source.tags[i].tagFQN.equalsIgnoreCase(params.tagDeleted[j].tagFQN)) { ctx._source.tags.remove(i); } } } } } if (ctx._source.tags == null) { ctx._source.tags = []; } if (params.tagAdded != null) { ctx._source.tags.addAll(params.tagAdded); } ctx._source.tags = ctx._source.tags .stream() .distinct() .sorted((o1, o2) -> o1.tagFQN.compareTo(o2.tagFQN)) .collect(Collectors.toList());";
    public static final String REMOVE_TEST_SUITE_CHILDREN_SCRIPT = "for (int i = 0; i < ctx._source.testSuites.length; i++) { if (ctx._source.testSuites[i].id == '%s') { ctx._source.testSuites.remove(i) }}";

    public boolean isClientAvailable();

    public ElasticSearchConfiguration.SearchType getSearchType();

    public boolean indexExists(String var1);

    public boolean createIndex(IndexMapping var1, String var2);

    public void updateIndex(IndexMapping var1, String var2);

    public void deleteIndex(IndexMapping var1);

    public void createAliases(IndexMapping var1);

    public Response search(SearchRequest var1) throws IOException;

    public Response searchBySourceUrl(String var1) throws IOException;

    public Response searchByField(String var1, String var2, String var3) throws IOException;

    public Response aggregate(String var1, String var2, String var3, String var4) throws IOException;

    public Response suggest(SearchRequest var1) throws IOException;

    public void createEntity(String var1, String var2, String var3);

    public void createTimeSeriesEntity(String var1, String var2, String var3);

    public void updateEntity(String var1, String var2, Map<String, Object> var3, String var4);

    public void deleteByScript(String var1, String var2, Map<String, Object> var3);

    public void deleteEntity(String var1, String var2);

    public void deleteEntityByFields(String var1, List<Pair<String, String>> var2);

    public void softDeleteOrRestoreEntity(String var1, String var2, String var3);

    public void softDeleteOrRestoreChildren(String var1, String var2, List<Pair<String, String>> var3);

    public void updateChildren(String var1, Pair<String, String> var2, Pair<String, Map<String, Object>> var3);

    public TreeMap<Long, List<Object>> getSortedDate(String var1, Long var2, Long var3, DataInsightChartResult.DataInsightChartType var4, String var5) throws IOException, ParseException;

    public Response listDataInsightChartResult(Long var1, Long var2, String var3, String var4, DataInsightChartResult.DataInsightChartType var5, Integer var6, Integer var7, String var8, String var9) throws IOException, ParseException;

    default public BulkResponse bulk(os.org.opensearch.action.bulk.BulkRequest data, RequestOptions options) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public es.org.elasticsearch.action.bulk.BulkResponse bulk(BulkRequest data, es.org.elasticsearch.client.RequestOptions options) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public int getSuccessFromBulkResponse(BulkResponse response) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public int getSuccessFromBulkResponse(es.org.elasticsearch.action.bulk.BulkResponse response) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    public void close();

    default public SSLContext createElasticSearchSSLContext(ElasticSearchConfiguration elasticSearchConfiguration) throws KeyStoreException {
        return elasticSearchConfiguration.getScheme().equals("https") ? SSLUtil.createSSLContext(elasticSearchConfiguration.getTruststorePath(), elasticSearchConfiguration.getTruststorePassword(), "ElasticSearch") : null;
    }
}

