/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.schema.entity.services.MlModelService;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.schema.entity.services.SearchService;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.service.search.indexes.AggregatedCostAnalysisReportDataIndex;
import org.openmetadata.service.search.indexes.ChartIndex;
import org.openmetadata.service.search.indexes.ClassificationIndex;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DashboardServiceIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.DatabaseIndex;
import org.openmetadata.service.search.indexes.DatabaseSchemaIndex;
import org.openmetadata.service.search.indexes.DatabaseServiceIndex;
import org.openmetadata.service.search.indexes.DomainIndex;
import org.openmetadata.service.search.indexes.EntityReportDataIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.MessagingServiceIndex;
import org.openmetadata.service.search.indexes.MetadataServiceIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.MlModelServiceIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.PipelineServiceIndex;
import org.openmetadata.service.search.indexes.QueryIndex;
import org.openmetadata.service.search.indexes.RawCostAnalysisReportDataIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.indexes.SearchServiceIndex;
import org.openmetadata.service.search.indexes.StorageServiceIndex;
import org.openmetadata.service.search.indexes.StoredProcedureIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TeamIndex;
import org.openmetadata.service.search.indexes.TestCaseIndex;
import org.openmetadata.service.search.indexes.TestSuiteIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.search.indexes.UserIndex;
import org.openmetadata.service.search.indexes.WebAnalyticEntityViewReportDataIndex;
import org.openmetadata.service.search.indexes.WebAnalyticUserActivityReportDataIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndexFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexFactory.class);

    private SearchIndexFactory() {
    }

    public static SearchIndex buildIndex(String entityType, Object entity) {
        switch (entityType) {
            case "table": {
                return new TableIndex((Table)entity);
            }
            case "dashboard": {
                return new DashboardIndex((Dashboard)entity);
            }
            case "topic": {
                return new TopicIndex((Topic)entity);
            }
            case "pipeline": {
                return new PipelineIndex((Pipeline)entity);
            }
            case "user": {
                return new UserIndex((User)entity);
            }
            case "team": {
                return new TeamIndex((Team)entity);
            }
            case "glossaryTerm": {
                return new GlossaryTermIndex((GlossaryTerm)entity);
            }
            case "mlmodel": {
                return new MlModelIndex((MlModel)entity);
            }
            case "tag": {
                return new TagIndex((Tag)entity);
            }
            case "classification": {
                return new ClassificationIndex((Classification)entity);
            }
            case "query": {
                return new QueryIndex((Query)entity);
            }
            case "container": {
                return new ContainerIndex((Container)entity);
            }
            case "database": {
                return new DatabaseIndex((Database)entity);
            }
            case "databaseSchema": {
                return new DatabaseSchemaIndex((DatabaseSchema)entity);
            }
            case "testCase": {
                return new TestCaseIndex((TestCase)entity);
            }
            case "testSuite": {
                return new TestSuiteIndex((TestSuite)entity);
            }
            case "chart": {
                return new ChartIndex((Chart)entity);
            }
            case "dashboardDataModel": {
                return new DashboardDataModelIndex((DashboardDataModel)entity);
            }
            case "dashboardService": {
                return new DashboardServiceIndex((DashboardService)entity);
            }
            case "databaseService": {
                return new DatabaseServiceIndex((DatabaseService)entity);
            }
            case "messagingService": {
                return new MessagingServiceIndex((MessagingService)entity);
            }
            case "mlmodelService": {
                return new MlModelServiceIndex((MlModelService)entity);
            }
            case "searchService": {
                return new SearchServiceIndex((SearchService)entity);
            }
            case "searchIndex": {
                return new SearchEntityIndex((org.openmetadata.schema.entity.data.SearchIndex)entity);
            }
            case "pipelineService": {
                return new PipelineServiceIndex((PipelineService)entity);
            }
            case "storageService": {
                return new StorageServiceIndex((StorageService)entity);
            }
            case "domain": {
                return new DomainIndex((Domain)entity);
            }
            case "storedProcedure": {
                return new StoredProcedureIndex((StoredProcedure)entity);
            }
            case "dataProduct": {
                return new DataProductIndex((DataProduct)entity);
            }
            case "metadataService": {
                return new MetadataServiceIndex((MetadataService)entity);
            }
            case "entityReportData": {
                return new EntityReportDataIndex((ReportData)entity);
            }
            case "webAnalyticEntityViewReportData": {
                return new WebAnalyticEntityViewReportDataIndex((ReportData)entity);
            }
            case "webAnalyticUserActivityReportData": {
                return new WebAnalyticUserActivityReportDataIndex((ReportData)entity);
            }
            case "rawCostAnalysisReportData": {
                return new RawCostAnalysisReportDataIndex((ReportData)entity);
            }
            case "aggregatedCostAnalysisReportData": {
                return new AggregatedCostAnalysisReportDataIndex((ReportData)entity);
            }
        }
        LOG.warn("Ignoring Entity Type {}", (Object)entityType);
        throw new IllegalArgumentException(String.format("Entity Type [%s] is not valid for Index Factory", entityType));
    }
}

