/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import es.org.elasticsearch.action.ActionListener;
import es.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import es.org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import es.org.elasticsearch.action.bulk.BulkItemResponse;
import es.org.elasticsearch.action.bulk.BulkRequest;
import es.org.elasticsearch.action.bulk.BulkResponse;
import es.org.elasticsearch.action.delete.DeleteRequest;
import es.org.elasticsearch.action.delete.DeleteResponse;
import es.org.elasticsearch.action.search.SearchResponse;
import es.org.elasticsearch.action.support.WriteRequest;
import es.org.elasticsearch.action.support.master.AcknowledgedResponse;
import es.org.elasticsearch.action.update.UpdateRequest;
import es.org.elasticsearch.action.update.UpdateResponse;
import es.org.elasticsearch.client.RequestOptions;
import es.org.elasticsearch.client.RestClient;
import es.org.elasticsearch.client.RestClientBuilder;
import es.org.elasticsearch.client.RestHighLevelClient;
import es.org.elasticsearch.client.RestHighLevelClientBuilder;
import es.org.elasticsearch.client.indices.CreateIndexRequest;
import es.org.elasticsearch.client.indices.CreateIndexResponse;
import es.org.elasticsearch.client.indices.GetIndexRequest;
import es.org.elasticsearch.client.indices.PutMappingRequest;
import es.org.elasticsearch.common.lucene.search.function.CombineFunction;
import es.org.elasticsearch.common.settings.Settings;
import es.org.elasticsearch.common.unit.Fuzziness;
import es.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import es.org.elasticsearch.core.TimeValue;
import es.org.elasticsearch.index.query.BoolQueryBuilder;
import es.org.elasticsearch.index.query.MatchQueryBuilder;
import es.org.elasticsearch.index.query.MultiMatchQueryBuilder;
import es.org.elasticsearch.index.query.Operator;
import es.org.elasticsearch.index.query.QueryBuilder;
import es.org.elasticsearch.index.query.QueryBuilders;
import es.org.elasticsearch.index.query.QueryStringQueryBuilder;
import es.org.elasticsearch.index.query.RangeQueryBuilder;
import es.org.elasticsearch.index.query.ScriptQueryBuilder;
import es.org.elasticsearch.index.query.TermQueryBuilder;
import es.org.elasticsearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import es.org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import es.org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import es.org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import es.org.elasticsearch.index.reindex.BulkByScrollResponse;
import es.org.elasticsearch.index.reindex.DeleteByQueryRequest;
import es.org.elasticsearch.index.reindex.UpdateByQueryRequest;
import es.org.elasticsearch.script.Script;
import es.org.elasticsearch.script.ScriptType;
import es.org.elasticsearch.search.SearchModule;
import es.org.elasticsearch.search.aggregations.AggregationBuilder;
import es.org.elasticsearch.search.aggregations.AggregationBuilders;
import es.org.elasticsearch.search.aggregations.BucketOrder;
import es.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import es.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import es.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import es.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import es.org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import es.org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import es.org.elasticsearch.search.builder.SearchSourceBuilder;
import es.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import es.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import es.org.elasticsearch.search.sort.SortOrder;
import es.org.elasticsearch.search.suggest.Suggest;
import es.org.elasticsearch.search.suggest.SuggestBuilder;
import es.org.elasticsearch.search.suggest.SuggestBuilders;
import es.org.elasticsearch.search.suggest.SuggestionBuilder;
import es.org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import es.org.elasticsearch.search.suggest.completion.context.CategoryQueryContext;
import es.org.elasticsearch.xcontent.DeprecationHandler;
import es.org.elasticsearch.xcontent.NamedXContentRegistry;
import es.org.elasticsearch.xcontent.XContentParser;
import es.org.elasticsearch.xcontent.XContentType;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.DataInsightInterface;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.search.EntityBuilderConstant;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUnusedAssetsCountAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUnusedAssetsSizeAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUsedvsUnusedAssetsCountAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchAggregatedUsedvsUnusedAssetsSizeAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchDailyActiveUsersAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchEntitiesDescriptionAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchEntitiesOwnerAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchMostActiveUsersAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchMostViewedEntitiesAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchPageViewsByEntitiesAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchServicesDescriptionAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchServicesOwnerAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchTotalEntitiesAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchTotalEntitiesByTierAggregator;
import org.openmetadata.service.search.elasticsearch.dataInsightAggregators.ElasticSearchUnusedAssetsAggregator;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.DomainIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.QueryIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.indexes.StoredProcedureIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TestCaseIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.search.indexes.UserIndex;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchClient
implements SearchClient {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchClient.class);
    private final RestHighLevelClient client;
    private final boolean isClientAvailable;
    private static final NamedXContentRegistry xContentRegistry;

    public ElasticSearchClient(ElasticSearchConfiguration esConfig) {
        this.client = this.createElasticSearchClient(esConfig);
        this.isClientAvailable = this.client != null;
    }

    @Override
    public boolean isClientAvailable() {
        return this.isClientAvailable;
    }

    @Override
    public boolean indexExists(String indexName) {
        try {
            GetIndexRequest gRequest = new GetIndexRequest(new String[]{indexName});
            gRequest.local(false);
            return this.client.indices().exists(gRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to check if index %s exists due to", indexName), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean createIndex(IndexMapping indexMapping, String indexMappingContent) {
        if (Boolean.TRUE.equals(this.isClientAvailable)) {
            try {
                CreateIndexRequest request = new CreateIndexRequest(indexMapping.getIndexName());
                request.source(indexMappingContent, XContentType.JSON);
                CreateIndexResponse createIndexResponse = this.client.indices().create(request, RequestOptions.DEFAULT);
                LOG.debug("{} Created {}", (Object)indexMapping.getIndexName(), (Object)createIndexResponse.isAcknowledged());
                this.createAliases(indexMapping);
            }
            catch (Exception e) {
                LOG.error("Failed to create Elastic Search indexes due to", (Throwable)e);
                return false;
            }
            return true;
        }
        LOG.error("Failed to create Elastic Search index as client is not property configured, Please check your OpenMetadata configuration");
        return false;
    }

    @Override
    public void createAliases(IndexMapping indexMapping) {
        try {
            HashSet<String> aliases = new HashSet<String>(indexMapping.getParentAliases());
            aliases.add(indexMapping.getAlias());
            IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().index(indexMapping.getIndexName()).aliases(aliases.toArray(new String[0]));
            IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest();
            aliasesRequest.addAliasAction(aliasAction);
            this.client.indices().updateAliases(aliasesRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to create alias for %s due to", indexMapping.getIndexName()), (Throwable)e);
        }
    }

    @Override
    public void updateIndex(IndexMapping indexMapping, String indexMappingContent) {
        try {
            PutMappingRequest request = new PutMappingRequest(new String[]{indexMapping.getIndexName()});
            JsonNode readProperties = JsonUtils.readTree(indexMappingContent).get("mappings");
            request.source(JsonUtils.getMap(readProperties));
            AcknowledgedResponse putMappingResponse = this.client.indices().putMapping(request, RequestOptions.DEFAULT);
            LOG.debug("{} Updated {}", (Object)indexMapping.getIndexMappingFile(), (Object)putMappingResponse.isAcknowledged());
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to Update Elastic Search index %s", indexMapping.getIndexName()));
        }
    }

    @Override
    public void deleteIndex(IndexMapping indexMapping) {
        try {
            DeleteIndexRequest request = new DeleteIndexRequest(indexMapping.getIndexName());
            AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
            LOG.debug("{} Deleted {}", (Object)indexMapping.getIndexName(), (Object)deleteIndexResponse.isAcknowledged());
        }
        catch (IOException e) {
            LOG.error("Failed to delete Elastic Search indexes due to", (Throwable)e);
        }
    }

    @Override
    public Response search(SearchRequest request) throws IOException {
        XContentParser filterParser;
        SearchSourceBuilder searchSourceBuilder = switch (request.getIndex()) {
            case "topic_search_index" -> ElasticSearchClient.buildTopicSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "dashboard_search_index" -> ElasticSearchClient.buildDashboardSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "pipeline_search_index" -> ElasticSearchClient.buildPipelineSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "mlmodel_search_index" -> ElasticSearchClient.buildMlModelSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "table_search_index" -> ElasticSearchClient.buildTableSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "user_search_index", "team_search_index" -> ElasticSearchClient.buildUserOrTeamSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "glossary_term_search_index" -> ElasticSearchClient.buildGlossaryTermSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "tag_search_index" -> ElasticSearchClient.buildTagSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "container_search_index" -> ElasticSearchClient.buildContainerSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "query_search_index" -> ElasticSearchClient.buildQuerySearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
            case "test_case_search_index", "test_suite_search_index" -> ElasticSearchClient.buildTestCaseSearch(request.getQuery(), request.getFrom(), request.getSize());
            case "stored_procedure_search_index" -> ElasticSearchClient.buildStoredProcedureSearch(request.getQuery(), request.getFrom(), request.getSize());
            case "dashboard_data_model_search_index" -> ElasticSearchClient.buildDashboardDataModelsSearch(request.getQuery(), request.getFrom(), request.getSize());
            case "search_entity_search_index" -> ElasticSearchClient.buildSearchEntitySearch(request.getQuery(), request.getFrom(), request.getSize());
            case "domain_search_index" -> ElasticSearchClient.buildDomainsSearch(request.getQuery(), request.getFrom(), request.getSize());
            case "raw_cost_analysis_report_data_index", "aggregated_cost_analysis_report_data_index" -> ElasticSearchClient.buildCostAnalysisReportDataSearch(request.getQuery(), request.getFrom(), request.getSize());
            case "data_product_search_index" -> ElasticSearchClient.buildDataProductSearch(request.getQuery(), request.getFrom(), request.getSize());
            default -> ElasticSearchClient.buildAggregateSearchBuilder(request.getQuery(), request.getFrom(), request.getSize());
        };
        if (!CommonUtil.nullOrEmpty((String)request.getQueryFilter()) && !request.getQueryFilter().equals("{}")) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getQueryFilter());
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (!CommonUtil.nullOrEmpty((String)request.getPostFilter())) {
            try {
                filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, request.getPostFilter());
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                searchSourceBuilder.postFilter(filter);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing post_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        if (request.getIndex().equalsIgnoreCase("all")) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.deleted())));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")));
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        } else if (request.getIndex().equalsIgnoreCase("domain_search_index") || request.getIndex().equalsIgnoreCase("data_product_search_index") || request.getIndex().equalsIgnoreCase("query_search_index") || request.getIndex().equalsIgnoreCase("raw_cost_analysis_report_data_index") || request.getIndex().equalsIgnoreCase("aggregated_cost_analysis_report_data_index")) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()));
        } else {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.termQuery((String)"deleted", (boolean)request.deleted())));
        }
        if (!CommonUtil.nullOrEmpty((String)request.getSortFieldParam())) {
            searchSourceBuilder.sort(request.getSortFieldParam(), SortOrder.fromString((String)request.getSortOrder()));
        }
        if (request.getIndex().equalsIgnoreCase("glossary_term_search_index")) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Approved")));
        }
        searchSourceBuilder.fetchSource(new FetchSourceContext(request.fetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        if (request.trackTotalHits()) {
            searchSourceBuilder.trackTotalHits(true);
        } else {
            searchSourceBuilder.trackTotalHitsUpTo(EntityBuilderConstant.MAX_RESULT_HITS.intValue());
        }
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new es.org.elasticsearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response searchBySourceUrl(String sourceUrl) throws IOException {
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{"all"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"sourceUrl", (String)sourceUrl)));
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response searchByField(String fieldName, String fieldValue, String index) throws IOException {
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.wildcardQuery((String)fieldName, (String)fieldValue));
        searchRequest.source(searchSourceBuilder);
        String response = this.client.search(searchRequest, RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response aggregate(String index, String fieldName, String value, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(filter);
        searchSourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)fieldName).field(fieldName)).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()).includeExclude(new IncludeExclude(value.toLowerCase(), null)).order(BucketOrder.key((boolean)true))).query((QueryBuilder)boolQueryBuilder).size(0);
        searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        String response = this.client.search(new es.org.elasticsearch.action.search.SearchRequest(new String[]{index}).source(searchSourceBuilder), RequestOptions.DEFAULT).toString();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
    }

    @Override
    public Response suggest(SearchRequest request) throws IOException {
        String fieldName = request.getFieldName();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        CompletionSuggestionBuilder suggestionBuilder = ((CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)fieldName).prefix(request.getQuery(), Fuzziness.AUTO).size(request.getSize())).skipDuplicates(true);
        if (fieldName.equalsIgnoreCase("suggest")) {
            suggestionBuilder.contexts(Collections.singletonMap("deleted", Collections.singletonList(CategoryQueryContext.builder().setCategory(String.valueOf(request.deleted())).build())));
        }
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("metadata-suggest", (SuggestionBuilder)suggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder).timeout(new TimeValue(30L, TimeUnit.SECONDS)).fetchSource(new FetchSourceContext(request.fetchSource(), (String[])request.getIncludeSourceFields().toArray(String[]::new), new String[0]));
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{request.getIndex()}).source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        Suggest suggest = searchResponse.getSuggest();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)suggest.toString()).build();
    }

    private static SearchSourceBuilder buildPipelineSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(PipelineIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field("displayName");
        highlightPipelineName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("tasks.name");
        highlightTasks.highlighterType("unified");
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("tasks.description");
        highlightTaskDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tasks.displayName.keyword").field("tasks.displayName.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildMlModelSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(MlModelIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightPipelineName = new HighlightBuilder.Field("displayName");
        highlightPipelineName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTasks = new HighlightBuilder.Field("mlFeatures.name");
        highlightTasks.highlighterType("unified");
        HighlightBuilder.Field highlightTaskDescriptions = new HighlightBuilder.Field("mlFeatures.description");
        highlightTaskDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightPipelineName);
        hb.field(highlightTasks);
        hb.field(highlightTaskDescriptions);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTopicSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(TopicIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTopicName = new HighlightBuilder.Field("displayName");
        highlightTopicName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightTopicName);
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.description").highlighterType("unified"));
        hb.field((HighlightBuilder.Field)new HighlightBuilder.Field("messageSchema.schemaFields.children.name").highlighterType("unified"));
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"messageSchema.schemaFields.name.keyword").field("messageSchema.schemaFields.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"fieldNames").field("fieldNames"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(DashboardIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDashboardName = new HighlightBuilder.Field("displayName");
        highlightDashboardName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightCharts = new HighlightBuilder.Field("charts.name");
        highlightCharts.highlighterType("unified");
        HighlightBuilder.Field highlightChartDescriptions = new HighlightBuilder.Field("charts.description");
        highlightChartDescriptions.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightDashboardName);
        hb.field(highlightCharts);
        hb.field(highlightChartDescriptions);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModels.displayName.keyword").field("dataModels.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"charts.displayName.keyword").field("charts.displayName.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTableSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryStringBuilder = QueryBuilders.queryStringQuery((String)query).fields(TableIndex.getFields()).type(MultiMatchQueryBuilder.Type.BEST_FIELDS).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        FieldValueFactorFunctionBuilder boostScoreBuilder = ScoreFunctionBuilders.fieldValueFactorFunction((String)"usageSummary.weeklyStats.count").missing(0.0).factor(0.2f);
        FunctionScoreQueryBuilder.FilterFunctionBuilder[] functions = new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{new FunctionScoreQueryBuilder.FilterFunctionBuilder((ScoreFunctionBuilder)boostScoreBuilder)};
        FunctionScoreQueryBuilder queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryStringBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])functions);
        queryBuilder.boostMode(CombineFunction.SUM);
        HighlightBuilder.Field highlightTableName = new HighlightBuilder.Field("displayName");
        highlightTableName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("columns.name");
        highlightColumns.highlighterType("unified");
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("columns.description");
        highlightColumnDescriptions.highlighterType("unified");
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("columns.children.name");
        highlightColumnDescriptions.highlighterType("unified");
        hb.field(highlightDescription);
        hb.field(highlightTableName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"database.displayName.keyword").field("database.displayName.keyword"));
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"databaseSchema.displayName.keyword").field("databaseSchema.displayName.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tableType").field("tableType"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildUserOrTeamSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(UserIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildGlossaryTermSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(GlossaryTermIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field("name");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder.Field highlightGlossaryDisplayName = new HighlightBuilder.Field("displayName");
        highlightGlossaryDisplayName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightSynonym = new HighlightBuilder.Field("synonyms");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.field(highlightGlossaryDisplayName);
        hb.field(highlightSynonym);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"glossary.name.keyword").field("glossary.name.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildTagSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(TagIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTagName = new HighlightBuilder.Field("name");
        highlightTagName.highlighterType("unified");
        HighlightBuilder.Field highlightTagDisplayName = new HighlightBuilder.Field("displayName");
        highlightTagDisplayName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightTagDisplayName);
        hb.field(highlightDescription);
        hb.field(highlightTagName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"classification.name.keyword").field("classification.name.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildContainerSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(ContainerIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightContainerName = new HighlightBuilder.Field("displayName");
        highlightContainerName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightColumns = new HighlightBuilder.Field("dataModel.columns.name");
        highlightColumns.highlighterType("unified");
        HighlightBuilder.Field highlightColumnDescriptions = new HighlightBuilder.Field("dataModel.columns.description");
        highlightColumnDescriptions.highlighterType("unified");
        HighlightBuilder.Field highlightColumnChildren = new HighlightBuilder.Field("dataModel.columns.children.name");
        highlightColumnDescriptions.highlighterType("unified");
        hb.field(highlightDescription);
        hb.field(highlightContainerName);
        hb.field(highlightColumns);
        hb.field(highlightColumnDescriptions);
        hb.field(highlightColumnChildren);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModel.columns.name.keyword").field("dataModel.columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildQuerySearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(QueryIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightGlossaryName = new HighlightBuilder.Field("displayName");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightQuery = new HighlightBuilder.Field("query");
        highlightGlossaryName.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightGlossaryName);
        hb.field(highlightQuery);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildTestCaseSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(TestCaseIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightTestCaseDescription = new HighlightBuilder.Field("description");
        highlightTestCaseDescription.highlighterType("unified");
        HighlightBuilder.Field highlightTestCaseName = new HighlightBuilder.Field("name");
        highlightTestCaseName.highlighterType("unified");
        HighlightBuilder.Field highlightTestSuiteName = new HighlightBuilder.Field("testSuite.name");
        highlightTestSuiteName.highlighterType("unified");
        HighlightBuilder.Field highlightTestSuiteDescription = new HighlightBuilder.Field("testSuite.description");
        highlightTestSuiteDescription.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightTestCaseDescription);
        hb.field(highlightTestCaseName);
        hb.field(highlightTestSuiteName);
        hb.field(highlightTestSuiteDescription);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildStoredProcedureSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(StoredProcedureIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightName = new HighlightBuilder.Field("name");
        highlightName.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDashboardDataModelsSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(DashboardDataModelIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightName = new HighlightBuilder.Field("name");
        highlightName.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"dataModelType").field("dataModelType")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columns.name.keyword").field("columns.name.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"project.keyword").field("project.keyword")).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"columnNames").field("columnNames"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDomainsSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(DomainIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightName = new HighlightBuilder.Field("name");
        highlightName.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, hb, from, size);
    }

    private static SearchSourceBuilder buildCostAnalysisReportDataSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query);
        return ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
    }

    private static SearchSourceBuilder buildSearchEntitySearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(SearchEntityIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightName = new HighlightBuilder.Field("name");
        highlightName.highlighterType("unified");
        HighlightBuilder.Field highlightDisplayName = new HighlightBuilder.Field("displayName");
        highlightDisplayName.highlighterType("unified");
        HighlightBuilder hb = new HighlightBuilder();
        hb.field(highlightDescription);
        hb.field(highlightName);
        hb.field(highlightDisplayName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        searchSourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"fields.name.keyword").field("fields.name.keyword"));
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildDataProductSearch(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(DataProductIndex.getFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        HighlightBuilder hb = new HighlightBuilder();
        HighlightBuilder.Field highlightDescription = new HighlightBuilder.Field("description");
        highlightDescription.highlighterType("unified");
        HighlightBuilder.Field highlightName = new HighlightBuilder.Field("name");
        highlightName.highlighterType("unified");
        HighlightBuilder.Field highlightDisplayName = new HighlightBuilder.Field("displayName");
        highlightDisplayName.highlighterType("unified");
        hb.field(highlightDescription);
        hb.field(highlightName);
        hb.field(highlightDisplayName);
        hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
        hb.postTags(new String[]{"</span>"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).highlighter(hb).from(from).size(size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder buildAggregateSearchBuilder(String query, int from, int size) {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)query).fields(SearchIndex.getAllFields()).defaultOperator(Operator.AND).fuzziness(Fuzziness.AUTO);
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.searchBuilder((QueryBuilder)queryBuilder, null, from, size);
        return ElasticSearchClient.addAggregation(searchSourceBuilder);
    }

    private static SearchSourceBuilder addAggregation(SearchSourceBuilder builder) {
        builder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceType").field("serviceType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"service.displayName.keyword").field("service.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("entityType")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"tier.tagFQN").field("tier.tagFQN")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"owner.displayName.keyword").field("owner.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"domain.displayName.keyword").field("domain.displayName.keyword")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue())).aggregation((AggregationBuilder)AggregationBuilders.terms((String)"tags.tagFQN").field("tags.tagFQN")).aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"index_count").field("_index")).size(EntityBuilderConstant.MAX_AGGREGATE_SIZE.intValue()));
        return builder;
    }

    private static SearchSourceBuilder searchBuilder(QueryBuilder queryBuilder, HighlightBuilder hb, int from, int size) {
        SearchSourceBuilder builder = new SearchSourceBuilder().query(queryBuilder).from(from).size(size);
        if (hb != null) {
            hb.preTags(new String[]{"<span class=\"text-highlighter\">"});
            hb.postTags(new String[]{"</span>"});
            builder.highlighter(hb);
        }
        return builder;
    }

    @Override
    public ElasticSearchConfiguration.SearchType getSearchType() {
        return ElasticSearchConfiguration.SearchType.ELASTICSEARCH;
    }

    @Override
    public void createEntity(String indexName, String docId, String doc) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            updateRequest.doc(doc, XContentType.JSON);
            updateRequest.docAsUpsert(true);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void createTimeSeriesEntity(String indexName, String docId, String doc) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            updateRequest.doc(doc, XContentType.JSON);
            updateRequest.docAsUpsert(true);
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void deleteByScript(String indexName, String scriptTxt, Map<String, Object> params) {
        if (this.isClientAvailable) {
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, params);
            ScriptQueryBuilder scriptQuery = new ScriptQueryBuilder(script);
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
            deleteByQueryRequest.setQuery((QueryBuilder)scriptQuery);
            this.deleteEntityFromElasticSearchByQuery(deleteByQueryRequest);
        }
    }

    @Override
    public void deleteEntity(String indexName, String docId) {
        if (this.isClientAvailable) {
            DeleteRequest deleteRequest = new DeleteRequest(indexName, docId);
            this.deleteEntityFromElasticSearch(deleteRequest);
        }
    }

    @Override
    public void deleteEntityByFields(String indexName, List<Pair<String, String>> fieldAndValue) {
        if (this.isClientAvailable) {
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
            for (Pair<String, String> p : fieldAndValue) {
                queryBuilder.must((QueryBuilder)new TermQueryBuilder((String)p.getKey(), (String)p.getValue()));
            }
            deleteByQueryRequest.setQuery((QueryBuilder)queryBuilder);
            this.deleteEntityFromElasticSearchByQuery(deleteByQueryRequest);
        }
    }

    @Override
    public void softDeleteOrRestoreEntity(String indexName, String docId, String scriptTxt) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateRequest.script(script);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void softDeleteOrRestoreChildren(String indexName, String scriptTxt, List<Pair<String, String>> fieldAndValue) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
            BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
            for (Pair<String, String> p : fieldAndValue) {
                queryBuilder.must((QueryBuilder)new TermQueryBuilder((String)p.getKey(), (String)p.getValue()));
            }
            updateByQueryRequest.setQuery((QueryBuilder)queryBuilder);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, new HashMap());
            updateByQueryRequest.setScript(script);
            this.updateElasticSearchByQuery(updateByQueryRequest);
        }
    }

    @Override
    public void updateEntity(String indexName, String docId, Map<String, Object> doc, String scriptTxt) {
        if (this.isClientAvailable) {
            UpdateRequest updateRequest = new UpdateRequest(indexName, docId);
            Script script = new Script(ScriptType.INLINE, "painless", scriptTxt, JsonUtils.getMap(doc));
            updateRequest.scriptedUpsert(true);
            updateRequest.script(script);
            this.updateElasticSearch(updateRequest);
        }
    }

    @Override
    public void updateChildren(String indexName, Pair<String, String> fieldAndValue, Pair<String, Map<String, Object>> updates) {
        if (this.isClientAvailable) {
            UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{indexName});
            updateByQueryRequest.setQuery((QueryBuilder)new MatchQueryBuilder((String)fieldAndValue.getKey(), fieldAndValue.getValue()).operator(Operator.AND));
            Script script = new Script(ScriptType.INLINE, "painless", (String)updates.getKey(), JsonUtils.getMap(updates.getValue() == null ? new HashMap() : updates.getValue()));
            updateByQueryRequest.setScript(script);
            this.updateElasticSearchByQuery(updateByQueryRequest);
        }
    }

    public void updateElasticSearch(UpdateRequest updateRequest) {
        if (updateRequest != null && this.isClientAvailable) {
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateRequest);
            ActionListener<UpdateResponse> listener = new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse updateResponse) {
                    LOG.debug("Created successfully: " + updateResponse.toString());
                }

                public void onFailure(Exception e) {
                    LOG.error("Creation failed: " + e.getMessage());
                }
            };
            this.client.updateAsync(updateRequest, RequestOptions.DEFAULT, (ActionListener)listener);
        }
    }

    private void updateElasticSearchByQuery(UpdateByQueryRequest updateByQueryRequest) {
        if (updateByQueryRequest != null && this.isClientAvailable) {
            updateByQueryRequest.setRefresh(true);
            LOG.debug("Sending request to ElasticSearch {}", (Object)updateByQueryRequest);
            ActionListener<BulkByScrollResponse> listener = new ActionListener<BulkByScrollResponse>(){

                public void onResponse(BulkByScrollResponse response) {
                    LOG.debug("Update by query succeeded: " + response.toString());
                }

                public void onFailure(Exception e) {
                    LOG.error("Update by query failed: " + e.getMessage());
                }
            };
            this.client.updateByQueryAsync(updateByQueryRequest, RequestOptions.DEFAULT, (ActionListener)listener);
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close elastic search", (Throwable)e);
        }
    }

    private void deleteEntityFromElasticSearch(DeleteRequest deleteRequest) {
        if (deleteRequest != null && this.isClientAvailable) {
            deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            ActionListener<DeleteResponse> listener = new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse response) {
                    LOG.debug("Delete succeeded: " + response.toString());
                }

                public void onFailure(Exception e) {
                    LOG.error("Delete failed: " + e.getMessage());
                }
            };
            deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
            this.client.deleteAsync(deleteRequest, RequestOptions.DEFAULT, (ActionListener)listener);
        }
    }

    private void deleteEntityFromElasticSearchByQuery(DeleteByQueryRequest deleteRequest) {
        if (deleteRequest != null && this.isClientAvailable) {
            LOG.debug("Sending request to ElasticSearch {}", (Object)deleteRequest);
            deleteRequest.setRefresh(true);
            ActionListener<BulkByScrollResponse> listener = new ActionListener<BulkByScrollResponse>(){

                public void onResponse(BulkByScrollResponse response) {
                    LOG.debug("Delete by query succeeded: " + response.toString());
                }

                public void onFailure(Exception e) {
                    LOG.error("Delete by query failed: " + e.getMessage());
                }
            };
            this.client.deleteByQueryAsync(deleteRequest, RequestOptions.DEFAULT, (ActionListener)listener);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest data, RequestOptions options) throws IOException {
        return this.client.bulk(data, RequestOptions.DEFAULT);
    }

    @Override
    public int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    @Override
    public TreeMap<Long, List<Object>> getSortedDate(String team, Long scheduleTime, Long currentTime, DataInsightChartResult.DataInsightChartType chartType, String indexName) throws IOException, ParseException {
        es.org.elasticsearch.action.search.SearchRequest searchRequestTotalAssets = ElasticSearchClient.buildSearchRequest(scheduleTime, currentTime, null, team, chartType, null, null, null, indexName);
        SearchResponse searchResponseTotalAssets = this.client.search(searchRequestTotalAssets, RequestOptions.DEFAULT);
        DataInsightChartResult processedDataTotalAssets = ElasticSearchClient.processDataInsightChartResult(searchResponseTotalAssets, chartType);
        TreeMap<Long, List<Object>> dateWithDataMap = new TreeMap<Long, List<Object>>();
        for (Object data : processedDataTotalAssets.getData()) {
            DataInsightInterface convertedData = (DataInsightInterface)data;
            Long timestamp = convertedData.getTimestamp();
            List<Object> totalEntitiesByTypeList = new ArrayList<DataInsightInterface>();
            if (dateWithDataMap.containsKey(timestamp)) {
                totalEntitiesByTypeList = dateWithDataMap.get(timestamp);
            }
            totalEntitiesByTypeList.add(convertedData);
            dateWithDataMap.put(timestamp, totalEntitiesByTypeList);
        }
        return dateWithDataMap;
    }

    @Override
    public Response listDataInsightChartResult(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, Integer size, Integer from, String queryFilter, String dataReportIndex) throws IOException, ParseException {
        es.org.elasticsearch.action.search.SearchRequest searchRequest = ElasticSearchClient.buildSearchRequest(startTs, endTs, tier, team, dataInsightChartName, size, from, queryFilter, dataReportIndex);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)ElasticSearchClient.processDataInsightChartResult(searchResponse, dataInsightChartName)).build();
    }

    private static DataInsightChartResult processDataInsightChartResult(SearchResponse searchResponse, DataInsightChartResult.DataInsightChartType dataInsightChartType) throws ParseException {
        DataInsightAggregatorInterface processor = ElasticSearchClient.createDataAggregator(searchResponse, dataInsightChartType);
        return processor.process(dataInsightChartType);
    }

    private static DataInsightAggregatorInterface createDataAggregator(SearchResponse aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) throws IllegalArgumentException {
        switch (dataInsightChartType) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                return new ElasticSearchEntitiesDescriptionAggregator(aggregations.getAggregations());
            }
            case PERCENTAGE_OF_SERVICES_WITH_DESCRIPTION: {
                return new ElasticSearchServicesDescriptionAggregator(aggregations.getAggregations());
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                return new ElasticSearchEntitiesOwnerAggregator(aggregations.getAggregations());
            }
            case PERCENTAGE_OF_SERVICES_WITH_OWNER: {
                return new ElasticSearchServicesOwnerAggregator(aggregations.getAggregations());
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                return new ElasticSearchTotalEntitiesAggregator(aggregations.getAggregations());
            }
            case TOTAL_ENTITIES_BY_TIER: {
                return new ElasticSearchTotalEntitiesByTierAggregator(aggregations.getAggregations());
            }
            case DAILY_ACTIVE_USERS: {
                return new ElasticSearchDailyActiveUsersAggregator(aggregations.getAggregations());
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                return new ElasticSearchPageViewsByEntitiesAggregator(aggregations.getAggregations());
            }
            case MOST_ACTIVE_USERS: {
                return new ElasticSearchMostActiveUsersAggregator(aggregations.getAggregations());
            }
            case MOST_VIEWED_ENTITIES: {
                return new ElasticSearchMostViewedEntitiesAggregator(aggregations.getAggregations());
            }
            case UNUSED_ASSETS: {
                return new ElasticSearchUnusedAssetsAggregator(aggregations.getHits());
            }
            case AGGREGATED_UNUSED_ASSETS_SIZE: {
                return new ElasticSearchAggregatedUnusedAssetsSizeAggregator(aggregations.getAggregations());
            }
            case AGGREGATED_UNUSED_ASSETS_COUNT: {
                return new ElasticSearchAggregatedUnusedAssetsCountAggregator(aggregations.getAggregations());
            }
            case AGGREGATED_USED_VS_UNUSED_ASSETS_COUNT: {
                return new ElasticSearchAggregatedUsedvsUnusedAssetsCountAggregator(aggregations.getAggregations());
            }
            case AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE: {
                return new ElasticSearchAggregatedUsedvsUnusedAssetsSizeAggregator(aggregations.getAggregations());
            }
        }
        throw new IllegalArgumentException(String.format("No processor found for chart Type %s ", dataInsightChartType));
    }

    private static es.org.elasticsearch.action.search.SearchRequest buildSearchRequest(Long startTs, Long endTs, String tier, String team, DataInsightChartResult.DataInsightChartType dataInsightChartName, Integer size, Integer from, String queryFilter, String dataReportIndex) {
        SearchSourceBuilder searchSourceBuilder = ElasticSearchClient.buildQueryFilter(startTs, endTs, tier, team, queryFilter, dataInsightChartName.value());
        if (!dataInsightChartName.toString().equalsIgnoreCase(DataInsightChartResult.DataInsightChartType.UNUSED_ASSETS.toString())) {
            AggregationBuilder aggregationBuilder = ElasticSearchClient.buildQueryAggregation(dataInsightChartName);
            searchSourceBuilder.aggregation(aggregationBuilder);
            searchSourceBuilder.timeout(new TimeValue(30L, TimeUnit.SECONDS));
        } else {
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.from(from.intValue());
            searchSourceBuilder.size(size.intValue());
            searchSourceBuilder.sort("data.lifeCycle.accessed.timestamp", SortOrder.DESC);
        }
        es.org.elasticsearch.action.search.SearchRequest searchRequest = new es.org.elasticsearch.action.search.SearchRequest(new String[]{dataReportIndex});
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private static SearchSourceBuilder buildQueryFilter(Long startTs, Long endTs, String tier, String team, String queryFilter, String dataInsightChartName) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder searchQueryFiler = new BoolQueryBuilder();
        if (team != null && DataInsightChartRepository.SUPPORTS_TEAM_FILTER.contains(dataInsightChartName)) {
            List<String> teamArray = Arrays.asList(team.split("\\s*,\\s*"));
            BoolQueryBuilder teamQueryFilter = QueryBuilders.boolQuery();
            teamQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.team", teamArray));
            searchQueryFiler.must((QueryBuilder)teamQueryFilter);
        }
        if (tier != null && DataInsightChartRepository.SUPPORTS_TIER_FILTER.contains(dataInsightChartName)) {
            List<String> tierArray = Arrays.asList(tier.split("\\s*,\\s*"));
            BoolQueryBuilder tierQueryFilter = QueryBuilders.boolQuery();
            tierQueryFilter.should((QueryBuilder)QueryBuilders.termsQuery((String)"data.entityTier", tierArray));
            searchQueryFiler.must((QueryBuilder)tierQueryFilter);
        }
        if (!DataInsightChartRepository.SUPPORTS_NULL_DATE_RANGE.contains(dataInsightChartName)) {
            if (startTs == null || endTs == null) {
                throw new IllegalArgumentException(String.format("Start and End date are required for chart type %s ", dataInsightChartName));
            }
            RangeQueryBuilder dateQueryFilter = QueryBuilders.rangeQuery((String)"timestamp").gte((Object)startTs).lte((Object)endTs);
            searchQueryFiler.must((QueryBuilder)dateQueryFilter);
        }
        searchSourceBuilder.query((QueryBuilder)searchQueryFiler).fetchSource(false);
        if (!CommonUtil.nullOrEmpty((String)queryFilter) && !queryFilter.equals("{}")) {
            try {
                XContentParser filterParser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, queryFilter);
                QueryBuilder filter = SearchSourceBuilder.fromXContent((XContentParser)filterParser).query();
                BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter(filter);
                searchSourceBuilder.query((QueryBuilder)newQuery);
            }
            catch (Exception ex) {
                LOG.warn("Error parsing query_filter from query parameters, ignoring filter", (Throwable)ex);
            }
        }
        return searchSourceBuilder;
    }

    private static AggregationBuilder buildQueryAggregation(DataInsightChartResult.DataInsightChartType dataInsightChartName) throws IllegalArgumentException {
        DateHistogramAggregationBuilder dateHistogramAggregationBuilder = ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"timestamp").field("timestamp")).calendarInterval(DateHistogramInterval.DAY);
        SumAggregationBuilder sumEntityCountAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"entityCount").field("data.entityCount");
        switch (dataInsightChartName) {
            case PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"completedDescriptionFraction").field("data.completedDescriptions");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case AGGREGATED_UNUSED_ASSETS_SIZE: 
            case AGGREGATED_UNUSED_ASSETS_COUNT: {
                boolean isSize = dataInsightChartName.equals((Object)DataInsightChartResult.DataInsightChartType.AGGREGATED_UNUSED_ASSETS_SIZE);
                String[] types = new String[]{"frequentlyUsedDataAssets", "unusedDataAssets"};
                String fieldType = isSize ? "size" : "count";
                for (String type : types) {
                    SumAggregationBuilder threeDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sThreeDays", type)).field(String.format("data.%s.%s.threeDays", type, fieldType));
                    SumAggregationBuilder sevenDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sSevenDays", type)).field(String.format("data.%s.%s.sevenDays", type, fieldType));
                    SumAggregationBuilder fourteenDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sFourteenDays", type)).field(String.format("data.%s.%s.fourteenDays", type, fieldType));
                    SumAggregationBuilder thirtyDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sThirtyDays", type)).field(String.format("data.%s.%s.thirtyDays", type, fieldType));
                    SumAggregationBuilder sixtyDaysAgg = (SumAggregationBuilder)AggregationBuilders.sum((String)String.format("%sSixtyDays", type)).field(String.format("data.%s.%s.sixtyDays", type, fieldType));
                    ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)threeDaysAgg)).subAggregation((AggregationBuilder)sevenDaysAgg)).subAggregation((AggregationBuilder)fourteenDaysAgg)).subAggregation((AggregationBuilder)thirtyDaysAgg)).subAggregation((AggregationBuilder)sixtyDaysAgg);
                }
                return dateHistogramAggregationBuilder;
            }
            case AGGREGATED_USED_VS_UNUSED_ASSETS_COUNT: 
            case AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE: {
                boolean isSizeReport = dataInsightChartName.equals((Object)DataInsightChartResult.DataInsightChartType.AGGREGATED_USED_VS_UNUSED_ASSETS_SIZE);
                String totalFieldString = isSizeReport ? "totalSize" : "totalCount";
                SumAggregationBuilder totalUnusedAssets = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUnused").field(String.format("data.unusedDataAssets.%s", totalFieldString));
                SumAggregationBuilder totalUsedAssets = (SumAggregationBuilder)AggregationBuilders.sum((String)"totalUsed").field(String.format("data.frequentlyUsedDataAssets.%s", totalFieldString));
                return ((DateHistogramAggregationBuilder)dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)totalUnusedAssets)).subAggregation((AggregationBuilder)totalUsedAssets);
            }
            case PERCENTAGE_OF_SERVICES_WITH_DESCRIPTION: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceName").field("data.serviceName")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"completedDescriptionFraction").field("data.completedDescriptions");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"hasOwnerFraction").field("data.hasOwner");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case PERCENTAGE_OF_SERVICES_WITH_OWNER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"serviceName").field("data.serviceName")).size(1000);
                SumAggregationBuilder sumAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"hasOwnerFraction").field("data.hasOwner");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumAggregationBuilder)).subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TIER: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityTier").field("data.entityTier")).missing((Object)"NoTier")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case TOTAL_ENTITIES_BY_TYPE: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityCountAggregationBuilder));
            }
            case DAILY_ACTIVE_USERS: {
                return dateHistogramAggregationBuilder;
            }
            case PAGE_VIEWS_BY_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType")).size(1000);
                SumAggregationBuilder sumPageViewsByEntityTypes = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return dateHistogramAggregationBuilder.subAggregation((AggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumPageViewsByEntityTypes));
            }
            case MOST_VIEWED_ENTITIES: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"entityFqn").field("data.entityFqn")).size(10).order(BucketOrder.aggregation((String)"pageViews", (boolean)false));
                TermsAggregationBuilder ownerTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"owner").field("data.owner");
                TermsAggregationBuilder entityTypeTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityType").field("data.entityType");
                TermsAggregationBuilder entityHrefAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"entityHref").field("data.entityHref");
                SumAggregationBuilder sumEntityPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.views");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumEntityPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)ownerTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityTypeTermsAggregationBuilder)).subAggregation((AggregationBuilder)entityHrefAggregationBuilder);
            }
            case MOST_ACTIVE_USERS: {
                TermsAggregationBuilder termsAggregationBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"userName").field("data.userName")).size(10).order(BucketOrder.aggregation((String)"sessions", (boolean)false));
                TermsAggregationBuilder teamTermsAggregationBuilder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"team").field("data.team");
                SumAggregationBuilder sumSessionAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessions").field("data.totalSessions");
                SumAggregationBuilder sumUserPageViewsAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"pageViews").field("data.totalPageView");
                MaxAggregationBuilder lastSessionAggregationBuilder = (MaxAggregationBuilder)AggregationBuilders.max((String)"lastSession").field("data.lastSession");
                SumAggregationBuilder sumSessionDurationAggregationBuilder = (SumAggregationBuilder)AggregationBuilders.sum((String)"sessionDuration").field("data.totalSessionDuration");
                return ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)termsAggregationBuilder.subAggregation((AggregationBuilder)sumSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumUserPageViewsAggregationBuilder)).subAggregation((AggregationBuilder)lastSessionAggregationBuilder)).subAggregation((AggregationBuilder)sumSessionDurationAggregationBuilder)).subAggregation((AggregationBuilder)teamTermsAggregationBuilder);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid dataInsightChartType name %s", dataInsightChartName));
    }

    public RestHighLevelClient createElasticSearchClient(ElasticSearchConfiguration esConfig) {
        if (esConfig != null) {
            try {
                RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esConfig.getHost(), esConfig.getPort().intValue(), esConfig.getScheme())});
                if (StringUtils.isNotEmpty((CharSequence)esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)esConfig.getPassword())) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                    SSLContext sslContext = this.createElasticSearchSSLContext(esConfig);
                    restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchClient.lambda$createElasticSearchClient$3((CredentialsProvider)credentialsProvider, sslContext, esConfig, arg_0));
                }
                restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(esConfig.getConnectionTimeoutSecs() * 1000).setSocketTimeout(esConfig.getSocketTimeoutSecs() * 1000));
                return new RestHighLevelClientBuilder(restClientBuilder.build()).setApiCompatibilityMode(Boolean.valueOf(true)).build();
            }
            catch (Exception e) {
                LOG.error("Failed to create elastic search client ", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticSearchClient$3(CredentialsProvider credentialsProvider, SSLContext sslContext, ElasticSearchConfiguration esConfig, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (sslContext != null) {
            httpAsyncClientBuilder.setSSLContext(sslContext);
        }
        if (esConfig.getKeepAliveTimeoutSecs() != null && esConfig.getKeepAliveTimeoutSecs() > 0) {
            httpAsyncClientBuilder.setKeepAliveStrategy((response, context) -> esConfig.getKeepAliveTimeoutSecs() * 1000);
        }
        return httpAsyncClientBuilder;
    }

    static {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, false, List.of());
        xContentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
    }
}

