/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ColumnIndex;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.FlattenColumn;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class ContainerIndex
implements ColumnIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final Container container;

    public ContainerIndex(Container container) {
        this.container = container;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.container);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> columnSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        HashSet<List<TagLabel>> tagsWithChildren = new HashSet<List<TagLabel>>();
        ArrayList<String> columnsWithChildrenName = new ArrayList<String>();
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        suggest.add(SearchSuggest.builder().input(this.container.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.container.getName()).weight(10).build());
        if (this.container.getDataModel() != null && this.container.getDataModel().getColumns() != null) {
            ArrayList<FlattenColumn> cols = new ArrayList<FlattenColumn>();
            this.parseColumns(this.container.getDataModel().getColumns(), cols, null);
            for (FlattenColumn col : cols) {
                columnSuggest.add(SearchSuggest.builder().input(col.getName()).weight(5).build());
                columnsWithChildrenName.add(col.getName());
                if (col.getTags() == null) continue;
                tagsWithChildren.add(col.getTags());
            }
            doc.put("columnNames", columnsWithChildrenName);
        }
        serviceSuggest.add(SearchSuggest.builder().input(this.container.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("container", (EntityInterface)this.container));
        tagsWithChildren.add(parseTags.getTags());
        List flattenedTagList = tagsWithChildren.stream().flatMap(Collection::stream).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        doc.put("displayName", this.container.getDisplayName() != null ? this.container.getDisplayName() : this.container.getName());
        doc.put("tags", flattenedTagList);
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.container.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("column_suggest", columnSuggest);
        doc.put("entityType", "container");
        doc.put("serviceType", this.container.getServiceType());
        doc.put("fqnParts", this.getFQNParts(this.container.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("owner", this.getEntityWithDisplayName(this.container.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.container.getService()));
        doc.put("domain", this.getEntityWithDisplayName(this.container.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("dataModel.columns.name", Float.valueOf(2.0f));
        fields.put("dataModel.columns.name.keyword", Float.valueOf(10.0f));
        fields.put("dataModel.columns.name.ngram", Float.valueOf(1.0f));
        fields.put("dataModel.columns.displayName", Float.valueOf(2.0f));
        fields.put("dataModel.columns.displayName.ngram", Float.valueOf(1.0f));
        fields.put("dataModel.columns.description", Float.valueOf(1.0f));
        fields.put("dataModel.columns.children.name", Float.valueOf(2.0f));
        return fields;
    }
}

