/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class DashboardServiceIndex
implements SearchIndex {
    final DashboardService dashboardService;
    private static final List<String> excludeFields = List.of("changeDescription");

    public DashboardServiceIndex(DashboardService dashboardService) {
        this.dashboardService = dashboardService;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.dashboardService);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dashboardService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dashboardService.getDisplayName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.dashboardService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "dashboardService");
        doc.put("owner", this.getEntityWithDisplayName(this.dashboardService.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.dashboardService.getDomain()));
        return doc;
    }
}

