/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class SearchEntityIndex
implements SearchIndex {
    final org.openmetadata.schema.entity.data.SearchIndex searchIndex;
    private static final List<String> excludeFields = List.of("changeDescription");

    public SearchEntityIndex(org.openmetadata.schema.entity.data.SearchIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.searchIndex);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.searchIndex.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.searchIndex.getFullyQualifiedName()).weight(5).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "searchIndex");
        doc.put("fqnParts", this.getFQNParts(this.searchIndex.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("searchIndex", (EntityInterface)this.searchIndex));
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("owner", this.getEntityWithDisplayName(this.searchIndex.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.searchIndex.getService()));
        doc.put("domain", this.getEntityWithDisplayName(this.searchIndex.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("fields.name", Float.valueOf(2.0f));
        fields.put("fields.name.keyword", Float.valueOf(2.0f));
        fields.put("fields.children.description", Float.valueOf(1.0f));
        fields.put("fields.children.name", Float.valueOf(2.0f));
        return fields;
    }
}

