/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.search.indexes.ContainerIndex;
import org.openmetadata.service.search.indexes.DashboardDataModelIndex;
import org.openmetadata.service.search.indexes.DashboardIndex;
import org.openmetadata.service.search.indexes.DataProductIndex;
import org.openmetadata.service.search.indexes.GlossaryTermIndex;
import org.openmetadata.service.search.indexes.MlModelIndex;
import org.openmetadata.service.search.indexes.PipelineIndex;
import org.openmetadata.service.search.indexes.SearchEntityIndex;
import org.openmetadata.service.search.indexes.TableIndex;
import org.openmetadata.service.search.indexes.TagIndex;
import org.openmetadata.service.search.indexes.TopicIndex;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public interface SearchIndex {
    public Map<String, Object> buildESDoc();

    default public Set<String> getFQNParts(String fqn, List<String> fqnSplits) {
        HashSet<String> fqnParts = new HashSet<String>();
        fqnParts.add(fqn);
        String parent = FullyQualifiedName.getParentFQN(fqn);
        while (parent != null) {
            fqnParts.add(parent);
            parent = FullyQualifiedName.getParentFQN(parent);
        }
        fqnParts.addAll(fqnSplits);
        return fqnParts;
    }

    default public EntityReference getEntityWithDisplayName(EntityReference entity) {
        EntityReference cloneEntity;
        if (entity == null) {
            return null;
        }
        cloneEntity.setDisplayName(CommonUtil.nullOrEmpty((String)(cloneEntity = JsonUtils.deepCopy(entity, EntityReference.class)).getDisplayName()) ? cloneEntity.getName() : cloneEntity.getDisplayName());
        return cloneEntity;
    }

    public static Map<String, Float> getDefaultFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(15.0f));
        fields.put("displayName.ngram", Float.valueOf(1.0f));
        fields.put("name", Float.valueOf(15.0f));
        fields.put("name.ngram", Float.valueOf(1.0f));
        fields.put("displayName.keyword", Float.valueOf(25.0f));
        fields.put("name.keyword", Float.valueOf(25.0f));
        fields.put("description", Float.valueOf(1.0f));
        fields.put("fullyQualifiedName", Float.valueOf(10.0f));
        fields.put("fqnParts", Float.valueOf(10.0f));
        return fields;
    }

    public static Map<String, Float> getAllFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.putAll(TableIndex.getFields());
        fields.putAll(DashboardIndex.getFields());
        fields.putAll(DashboardDataModelIndex.getFields());
        fields.putAll(PipelineIndex.getFields());
        fields.putAll(TopicIndex.getFields());
        fields.putAll(MlModelIndex.getFields());
        fields.putAll(ContainerIndex.getFields());
        fields.putAll(SearchEntityIndex.getFields());
        fields.putAll(GlossaryTermIndex.getFields());
        fields.putAll(TagIndex.getFields());
        fields.putAll(DataProductIndex.getFields());
        return fields;
    }
}

