/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.StoredProcedure;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class StoredProcedureIndex
implements SearchIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final StoredProcedure storedProcedure;

    public StoredProcedureIndex(StoredProcedure storedProcedure) {
        this.storedProcedure = storedProcedure;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.storedProcedure);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.storedProcedure.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.storedProcedure.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "storedProcedure");
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("storedProcedure", (EntityInterface)this.storedProcedure));
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("owner", this.getEntityWithDisplayName(this.storedProcedure.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.storedProcedure.getService()));
        doc.put("domain", this.getEntityWithDisplayName(this.storedProcedure.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

