/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class TestSuiteIndex
implements SearchIndex {
    final TestSuite testSuite;
    private static final List<String> excludeFields = List.of("changeDescription");

    public TestSuiteIndex(TestSuite testSuite) {
        this.testSuite = testSuite;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.testSuite);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.testSuite.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.testSuite.getName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.testSuite.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "testSuite");
        doc.put("owner", this.getEntityWithDisplayName(this.testSuite.getOwner()));
        return doc;
    }
}

