/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.api.teams.CreateUser;
import org.openmetadata.schema.auth.ChangePasswordRequest;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.LoginRequest;
import org.openmetadata.schema.auth.PasswordResetRequest;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.RegistrationRequest;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.schema.auth.TokenRefreshRequest;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;

public interface AuthenticatorHandler {
    public void init(OpenMetadataApplicationConfig var1);

    public JwtResponse loginUser(LoginRequest var1) throws IOException, TemplateException;

    public void checkIfLoginBlocked(String var1);

    public void recordFailedLoginAttempt(String var1, User var2) throws TemplateException, IOException;

    public void validatePassword(String var1, User var2, String var3) throws TemplateException, IOException;

    public User lookUserInProvider(String var1);

    default public User registerUser(RegistrationRequest registrationRequest) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void sendEmailVerification(UriInfo uriInfo, User user) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void confirmEmailRegistration(UriInfo uriInfo, String emailToken) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void resendRegistrationToken(UriInfo uriInfo, User registeredUser) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void sendPasswordResetLink(UriInfo uriInfo, User user, String subject, String templateFilePath) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void resetUserPasswordWithToken(UriInfo uriInfo, PasswordResetRequest req) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void changeUserPwdWithOldPwd(UriInfo uriInfo, String userName, ChangePasswordRequest req) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public RefreshToken createRefreshTokenForLogin(UUID currentUserId) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public JwtResponse getNewAccessToken(TokenRefreshRequest request) {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public void sendInviteMailToUser(UriInfo uriInfo, User user, String subject, CreateUser.CreatePasswordType requestType, String pwd) throws IOException {
        throw new CustomExceptionMessage(Response.Status.NOT_IMPLEMENTED, "Method not implemented.");
    }

    default public JwtResponse getJwtResponse(User storedUser, long expireInSeconds) {
        RefreshToken refreshToken = this.createRefreshTokenForLogin(storedUser.getId());
        JWTAuthMechanism jwtAuthMechanism = JWTTokenGenerator.getInstance().generateJWTToken(storedUser.getName(), storedUser.getEmail(), expireInSeconds, false, ServiceTokenType.OM_USER);
        JwtResponse response = new JwtResponse();
        response.setTokenType("Bearer");
        response.setAccessToken(jwtAuthMechanism.getJWTToken());
        response.setRefreshToken(refreshToken.getToken().toString());
        response.setExpiryDuration(jwtAuthMechanism.getJWTTokenExpiresAt());
        return response;
    }
}

