/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.resources.settings.SettingsCache;

public class LoginAttemptCache {
    private int maxAttempt = 3;
    private final LoadingCache<String, Integer> attemptsCache;

    public LoginAttemptCache(OpenMetadataApplicationConfig config) {
        LoginConfiguration loginConfiguration = SettingsCache.getSetting(SettingsType.LOGIN_CONFIGURATION, LoginConfiguration.class);
        long accessBlockTime = 600L;
        if (loginConfiguration != null) {
            this.maxAttempt = loginConfiguration.getMaxLoginFailAttempts();
            accessBlockTime = loginConfiguration.getAccessBlockTime().intValue();
        }
        this.attemptsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(accessBlockTime, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Integer>(){

            @NotNull
            public Integer load(@NonNull String username) {
                if (username == null) {
                    throw new NullPointerException("username is marked non-null but is null");
                }
                return 0;
            }
        });
    }

    public LoginAttemptCache(int maxAttempt, int blockTimeInSec) {
        this.maxAttempt = maxAttempt;
        this.attemptsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)blockTimeInSec, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Integer>(){

            @NotNull
            public Integer load(@NonNull String username) {
                if (username == null) {
                    throw new NullPointerException("username is marked non-null but is null");
                }
                return 0;
            }
        });
    }

    public void recordSuccessfulLogin(String username) {
        this.attemptsCache.invalidate((Object)username.toLowerCase());
    }

    public void recordFailedLogin(String username) {
        int attempts;
        try {
            attempts = (Integer)this.attemptsCache.get((Object)username.toLowerCase());
        }
        catch (ExecutionException e) {
            attempts = 0;
        }
        this.attemptsCache.put((Object)username, (Object)(++attempts));
    }

    public boolean isLoginBlocked(String username) {
        try {
            return (Integer)this.attemptsCache.get((Object)username.toLowerCase()) >= this.maxAttempt;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public int getUserFailedLoginCount(String username) {
        try {
            return (Integer)this.attemptsCache.get((Object)username.toLowerCase());
        }
        catch (ExecutionException e) {
            return -1;
        }
    }
}

