/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.stream.Collectors;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectContext {
    private static final Logger LOG = LoggerFactory.getLogger(SubjectContext.class);
    private static final String USER_FIELDS = "roles,teams,isAdmin,profile";
    public static final String TEAM_FIELDS = "defaultRoles, policies, parents, profile";
    protected final User user;

    protected SubjectContext(User user) {
        this.user = user;
    }

    public static SubjectContext getSubjectContext(String userName) {
        User user = (User)Entity.getEntityByName("user", userName, USER_FIELDS, Include.NON_DELETED);
        return new SubjectContext(user);
    }

    public boolean isAdmin() {
        return Boolean.TRUE.equals(this.user.getIsAdmin());
    }

    public boolean isBot() {
        return Boolean.TRUE.equals(this.user.getIsBot());
    }

    public boolean isOwner(EntityReference owner) {
        if (owner == null) {
            return false;
        }
        if (owner.getType().equals("user") && owner.getName().equals(this.user.getName())) {
            return true;
        }
        if (owner.getType().equals("team")) {
            for (EntityReference userTeam : CommonUtil.listOrEmpty((List)this.user.getTeams())) {
                if (!userTeam.getName().equals(owner.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUserUnderTeam(String parentTeam) {
        for (EntityReference userTeam : CommonUtil.listOrEmpty((List)this.user.getTeams())) {
            if (!SubjectContext.isInTeam(parentTeam, userTeam)) continue;
            return true;
        }
        return false;
    }

    public boolean isTeamAsset(String parentTeam, EntityReference owner) {
        if (owner.getType().equals("user")) {
            SubjectContext subjectContext = SubjectContext.getSubjectContext(owner.getName());
            return subjectContext.isUserUnderTeam(parentTeam);
        }
        if (owner.getType().equals("team")) {
            try {
                Team team = (Team)Entity.getEntity("team", owner.getId(), TEAM_FIELDS, Include.NON_DELETED);
                return SubjectContext.isInTeam(parentTeam, team.getEntityReference());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isInTeam(String parentTeam, EntityReference team) {
        ArrayDeque<EntityReference> stack = new ArrayDeque<EntityReference>();
        stack.push(team);
        while (!stack.isEmpty()) {
            try {
                Team parent = (Team)Entity.getEntity("team", ((EntityReference)stack.pop()).getId(), "parents", Include.NON_DELETED);
                if (parent.getName().equals(parentTeam)) {
                    return true;
                }
                CommonUtil.listOrEmpty((List)parent.getParents()).forEach(stack::push);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static List<EntityReference> getRolesForTeams(List<EntityReference> teams) {
        ArrayList<EntityReference> roles = new ArrayList<EntityReference>();
        for (EntityReference teamRef : CommonUtil.listOrEmpty(teams)) {
            try {
                Team team = (Team)Entity.getEntity("team", teamRef.getId(), TEAM_FIELDS, Include.NON_DELETED);
                roles.addAll(team.getDefaultRoles());
                roles.addAll(SubjectContext.getRolesForTeams(team.getParents()));
            }
            catch (Exception exception) {}
        }
        return roles.stream().distinct().collect(Collectors.toList());
    }

    public Iterator<PolicyContext> getPolicies(EntityReference resourceOwner) {
        return new UserPolicyIterator(this.user, resourceOwner, new ArrayList<UUID>());
    }

    public List<EntityReference> getTeams() {
        return this.user.getTeams();
    }

    public boolean hasAnyRole(String roles) {
        return SubjectContext.hasRole(this.getUser(), roles);
    }

    public static boolean hasRole(User user, String role) {
        ArrayDeque stack = new ArrayDeque();
        if (SubjectContext.hasRole(user.getRoles(), role)) {
            return true;
        }
        CommonUtil.listOrEmpty((List)user.getTeams()).forEach(stack::push);
        while (!stack.isEmpty()) {
            try {
                Team parent = (Team)Entity.getEntity("team", ((EntityReference)stack.pop()).getId(), TEAM_FIELDS, Include.NON_DELETED);
                if (SubjectContext.hasRole(parent.getDefaultRoles(), role)) {
                    return true;
                }
                CommonUtil.listOrEmpty((List)parent.getParents()).forEach(stack::push);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private static boolean hasRole(List<EntityReference> userRoles, String expectedRole) {
        return CommonUtil.listOrEmpty(userRoles).stream().anyMatch(userRole -> userRole.getName().equals(expectedRole));
    }

    public User getUser() {
        return this.user;
    }

    static class UserPolicyIterator
    implements Iterator<PolicyContext> {
        private final User user;
        private int iteratorIndex = 0;
        private final List<Iterator<PolicyContext>> iterators = new ArrayList<Iterator<PolicyContext>>();

        UserPolicyIterator(User user, EntityReference resourceOwner, List<UUID> teamsVisited) {
            this.user = user;
            if (!CommonUtil.listOrEmpty((List)user.getRoles()).isEmpty()) {
                this.iterators.add(new RolePolicyIterator("user", user.getName(), user.getRoles()));
            }
            if (!Boolean.TRUE.equals(user.getIsBot())) {
                for (EntityReference team : user.getTeams()) {
                    this.iterators.add(new TeamPolicyIterator(team.getId(), teamsVisited, false));
                }
            }
            if (resourceOwner != null && resourceOwner.getType().equals("team")) {
                try {
                    Team team = (Team)Entity.getEntity("team", resourceOwner.getId(), SubjectContext.TEAM_FIELDS, Include.NON_DELETED);
                    this.iterators.add(new TeamPolicyIterator(team.getId(), teamsVisited, true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasNext() {
            while (this.iteratorIndex < this.iterators.size()) {
                if (this.iterators.get(this.iteratorIndex).hasNext()) {
                    return true;
                }
                ++this.iteratorIndex;
            }
            LOG.debug("Subject {} policy iteration done", (Object)this.user.getName());
            return false;
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterators.get(this.iteratorIndex).next();
        }
    }

    static class TeamPolicyIterator
    implements Iterator<PolicyContext> {
        private int iteratorIndex = 0;
        private final List<Iterator<PolicyContext>> iterators = new ArrayList<Iterator<PolicyContext>>();

        TeamPolicyIterator(UUID teamId, List<UUID> teamsVisited, boolean skipRoles) {
            Team team = (Team)Entity.getEntity("team", teamId, SubjectContext.TEAM_FIELDS, Include.NON_DELETED);
            if (!teamsVisited.contains(teamId)) {
                teamsVisited.add(teamId);
                if (!skipRoles && team.getDefaultRoles() != null) {
                    this.iterators.add(new RolePolicyIterator("team", team.getName(), team.getDefaultRoles()));
                }
                if (team.getPolicies() != null) {
                    this.iterators.add(new PolicyIterator("team", team.getName(), null, team.getPolicies()));
                }
                for (EntityReference parentTeam : CommonUtil.listOrEmpty((List)team.getParents())) {
                    this.iterators.add(new TeamPolicyIterator(parentTeam.getId(), teamsVisited, skipRoles));
                }
            }
        }

        @Override
        public boolean hasNext() {
            while (this.iteratorIndex < this.iterators.size()) {
                if (this.iterators.get(this.iteratorIndex).hasNext()) {
                    return true;
                }
                ++this.iteratorIndex;
            }
            return false;
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterators.get(this.iteratorIndex).next();
        }
    }

    static class RolePolicyIterator
    implements Iterator<PolicyContext> {
        private final String entityType;
        private final String entityName;
        private int iteratorIndex = 0;
        private final List<PolicyIterator> policyIterators = new ArrayList<PolicyIterator>();

        RolePolicyIterator(String entityType, String entityName, List<EntityReference> roles) {
            this.entityType = entityType;
            this.entityName = entityName;
            for (EntityReference role : CommonUtil.listOrEmpty(roles)) {
                Role roleEntity = (Role)Entity.getEntity("role", role.getId(), "policies", Include.NON_DELETED);
                this.policyIterators.add(new PolicyIterator(entityType, entityName, role.getName(), roleEntity.getPolicies()));
            }
        }

        @Override
        public boolean hasNext() {
            while (this.iteratorIndex < this.policyIterators.size()) {
                if (this.policyIterators.get(this.iteratorIndex).hasNext()) {
                    return true;
                }
                ++this.iteratorIndex;
            }
            LOG.debug("iteration over roles attached to entity {}:{} is completed", (Object)this.entityType, (Object)this.entityName);
            return false;
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.policyIterators.get(this.iteratorIndex).next();
        }
    }

    static class PolicyIterator
    implements Iterator<PolicyContext> {
        private final String entityType;
        private final String entityName;
        private final String roleName;
        private int policyIndex = 0;
        private final List<EntityReference> policies;

        PolicyIterator(String entityType, String entityName, String roleName, List<EntityReference> policies) {
            this.entityType = entityType;
            this.entityName = entityName;
            this.roleName = roleName;
            this.policies = CommonUtil.listOrEmpty(policies);
        }

        @Override
        public boolean hasNext() {
            if (this.policyIndex >= this.policies.size()) {
                LOG.debug("iteration over policy attached to entity {}:{} role {} is completed", new Object[]{this.entityType, this.entityName, this.roleName});
            }
            return this.policyIndex < this.policies.size();
        }

        @Override
        public PolicyContext next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EntityReference policy = this.policies.get(this.policyIndex++);
            return new PolicyContext(this.entityType, this.entityName, this.roleName, policy.getName(), PolicyIterator.getPolicyRules(policy.getId()));
        }

        private static List<CompiledRule> getPolicyRules(UUID policyId) {
            Policy policy = (Policy)Entity.getEntity("policy", policyId, "rules", Include.NON_DELETED);
            ArrayList<CompiledRule> rules = new ArrayList<CompiledRule>();
            for (Rule r : policy.getRules()) {
                rules.add(new CompiledRule(r));
            }
            return rules;
        }
    }

    static class PolicyContext {
        private final String entityType;
        private final String entityName;
        private final String roleName;
        private final String policyName;
        private final List<CompiledRule> rules;

        PolicyContext(String entityType, String entityName, String role, String policy, List<CompiledRule> rules) {
            this.entityType = entityType;
            this.entityName = entityName;
            this.roleName = role;
            this.policyName = policy;
            this.rules = rules;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public List<CompiledRule> getRules() {
            return this.rules;
        }
    }
}

