/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.TriggerConfig;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Profile;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.util.ResultList;
import org.quartz.CronScheduleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionUtil.class);

    public static Set<String> getAdminsData(CreateEventSubscription.SubscriptionType type) {
        HashSet<String> data = new HashSet<String>();
        UserRepository userEntityRepository = (UserRepository)Entity.getEntityRepository("user");
        ListFilter listFilter = new ListFilter(Include.ALL);
        listFilter.addQueryParam("isAdmin", "true");
        String after = null;
        try {
            ResultList result;
            do {
                result = userEntityRepository.listAfter(null, userEntityRepository.getFields("email,profile"), listFilter, 50, after);
                result.getData().forEach(user -> {
                    if (type == CreateEventSubscription.SubscriptionType.EMAIL || type == CreateEventSubscription.SubscriptionType.DATA_INSIGHT) {
                        data.add(user.getEmail());
                    } else {
                        Profile userProfile = user.getProfile();
                        data.addAll(SubscriptionUtil.getWebhookUrlsFromProfile(userProfile, user.getId(), "user", type));
                    }
                });
            } while ((after = result.getPaging().getAfter()) != null);
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Users , Reason", (Throwable)ex);
        }
        return data;
    }

    public static Set<String> getOwnerOrFollowers(CreateEventSubscription.SubscriptionType type, CollectionDAO daoCollection, UUID entityId, String entityType, Relationship relationship) {
        HashSet<String> data = new HashSet<String>();
        try {
            List<CollectionDAO.EntityRelationshipRecord> ownerOrFollowers = daoCollection.relationshipDAO().findFrom(entityId, entityType, relationship.ordinal());
            ownerOrFollowers.forEach(owner -> {
                if (type == CreateEventSubscription.SubscriptionType.EMAIL || type == CreateEventSubscription.SubscriptionType.DATA_INSIGHT) {
                    if ("user".equals(owner.getType())) {
                        User user = (User)Entity.getEntity("user", owner.getId(), "", Include.NON_DELETED);
                        data.add(user.getEmail());
                    } else {
                        Team team = (Team)Entity.getEntity("team", owner.getId(), "", Include.NON_DELETED);
                        data.add(team.getEmail());
                    }
                } else {
                    Profile profile = null;
                    if ("user".equals(owner.getType())) {
                        User user = (User)Entity.getEntity("user", owner.getId(), "", Include.NON_DELETED);
                        profile = user.getProfile();
                    } else if ("team".equals(owner.getType())) {
                        Team team = (Team)Entity.getEntity("team", owner.getId(), "", Include.NON_DELETED);
                        profile = team.getProfile();
                    }
                    data.addAll(SubscriptionUtil.getWebhookUrlsFromProfile(profile, owner.getId(), owner.getType(), type));
                }
            });
        }
        catch (Exception ex) {
            LOG.error("Failed in listing all Owners/Followers, Reason : ", (Throwable)ex);
        }
        return data;
    }

    private static Set<String> getWebhookUrlsFromProfile(Profile profile, UUID id, String entityType, CreateEventSubscription.SubscriptionType type) {
        HashSet<String> webhookUrls = new HashSet<String>();
        if (profile != null) {
            Webhook webhookConfig = null;
            switch (type) {
                case SLACK_WEBHOOK: {
                    webhookConfig = profile.getSubscription().getSlack();
                    break;
                }
                case MS_TEAMS_WEBHOOK: {
                    webhookConfig = profile.getSubscription().getMsTeams();
                    break;
                }
                case G_CHAT_WEBHOOK: {
                    webhookConfig = profile.getSubscription().getgChat();
                    break;
                }
                case GENERIC_WEBHOOK: {
                    webhookConfig = profile.getSubscription().getGeneric();
                }
            }
            if (webhookConfig != null && !CommonUtil.nullOrEmpty((Object)webhookConfig.getEndpoint())) {
                webhookUrls.add(webhookConfig.getEndpoint().toString());
            } else {
                LOG.debug("[GetWebhookUrlsFromProfile] Owner with id {} type {}, will not get any Notification as not webhook config is invalid for type {}, webhookConfig {} ", new Object[]{id, entityType, type.value(), webhookConfig});
            }
        } else {
            LOG.debug("[GetWebhookUrlsFromProfile] Failed to Get Profile for Owner with ID : {} and type {} ", (Object)id, (Object)type);
        }
        return webhookUrls;
    }

    public static Set<String> buildReceiversListFromActions(SubscriptionAction action, CreateEventSubscription.SubscriptionType type, CollectionDAO daoCollection, UUID entityId, String entityType) {
        HashSet<String> receiverList = new HashSet<String>();
        if (Boolean.TRUE.equals(action.getSendToAdmins())) {
            receiverList.addAll(SubscriptionUtil.getAdminsData(type));
        }
        if (Boolean.TRUE.equals(action.getSendToOwners())) {
            receiverList.addAll(SubscriptionUtil.getOwnerOrFollowers(type, daoCollection, entityId, entityType, Relationship.OWNS));
        }
        if (Boolean.TRUE.equals(action.getSendToFollowers())) {
            receiverList.addAll(SubscriptionUtil.getOwnerOrFollowers(type, daoCollection, entityId, entityType, Relationship.FOLLOWS));
        }
        return receiverList;
    }

    public static List<Invocation.Builder> getTargetsForWebhook(SubscriptionAction action, CreateEventSubscription.SubscriptionType type, Client client, CollectionDAO daoCollection, ChangeEvent event) {
        EntityInterface entityInterface = AlertsRuleEvaluator.getEntity(event);
        ArrayList<Invocation.Builder> targets = new ArrayList<Invocation.Builder>();
        Set<String> receiversUrls = SubscriptionUtil.buildReceiversListFromActions(action, type, daoCollection, entityInterface.getId(), event.getEntityType());
        for (String url : receiversUrls) {
            targets.add(client.target(url).request());
        }
        return targets;
    }

    public static void postWebhookMessage(SubscriptionPublisher publisher, Invocation.Builder target, Object message) throws InterruptedException {
        long attemptTime = System.currentTimeMillis();
        Response response = target.post(javax.ws.rs.client.Entity.entity((Object)message, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        LOG.debug("Subscription Publisher Posted Message {}:{} received response {}", new Object[]{publisher.getEventSubscription().getName(), publisher.getEventSubscription().getBatchSize(), response.getStatusInfo()});
        if (response.getStatus() >= 300 && response.getStatus() < 400) {
            publisher.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
        } else if (response.getStatus() >= 400 && response.getStatus() < 600) {
            publisher.setNextBackOff();
            publisher.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
            Thread.sleep(publisher.getCurrentBackOff());
        } else if (response.getStatus() == 200) {
            publisher.setSuccessStatus(System.currentTimeMillis());
        }
    }

    public static Client getClient(int connectTimeout, int readTimeout) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)connectTimeout, TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)readTimeout, TimeUnit.SECONDS);
        return clientBuilder.build();
    }

    public static CronScheduleBuilder getCronSchedule(TriggerConfig trigger) {
        if (trigger.getTriggerType() == TriggerConfig.TriggerType.SCHEDULED) {
            TriggerConfig.ScheduleInfo scheduleInfo = trigger.getScheduleInfo();
            switch (scheduleInfo) {
                case DAILY: {
                    return CronScheduleBuilder.dailyAtHourAndMinute((int)0, (int)0);
                }
                case WEEKLY: {
                    return CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)7, (int)0, (int)0);
                }
                case MONTHLY: {
                    return CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)1, (int)0, (int)0);
                }
                case CUSTOM: {
                    if (!CommonUtil.nullOrEmpty((String)trigger.getCronExpression())) {
                        return CronScheduleBuilder.cronSchedule((String)trigger.getCronExpression());
                    }
                    throw new IllegalArgumentException("Missing Cron Expression for Custom Schedule.");
                }
            }
        }
        throw new IllegalArgumentException("Invalid Trigger Type, Can only be Scheduled.");
    }
}

