/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.health.conf.HealthConfiguration;
import io.dropwizard.health.core.HealthCheckBundle;
import io.dropwizard.jdbi3.JdbiFactory;
import io.dropwizard.jersey.errors.EarlyEofExceptionMapper;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import io.dropwizard.jersey.jackson.JsonProcessingExceptionMapper;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import io.socket.engineio.server.EngineIoServerOptions;
import io.socket.engineio.server.JettyWebSocketHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Optional;
import javax.naming.ConfigurationException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.server.NativeWebSocketServletContainerInitializer;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.locator.SqlLocator;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.service.Entity;
import org.openmetadata.service.JsonPatchProvider;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.OpenMetadataServerHealthCheck;
import org.openmetadata.service.apps.scheduler.AppScheduler;
import org.openmetadata.service.config.OMWebBundle;
import org.openmetadata.service.config.OMWebConfiguration;
import org.openmetadata.service.events.EventFilter;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.events.scheduled.EventSubscriptionScheduler;
import org.openmetadata.service.events.scheduled.PipelineServiceStatusJobHandler;
import org.openmetadata.service.exception.CatalogGenericExceptionMapper;
import org.openmetadata.service.exception.ConstraintViolationExceptionMapper;
import org.openmetadata.service.exception.JsonMappingExceptionMapper;
import org.openmetadata.service.exception.OMErrorPageHandler;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareAnnotationSqlLocator;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.migration.Migration;
import org.openmetadata.service.migration.api.MigrationWorkflow;
import org.openmetadata.service.monitoring.EventMonitor;
import org.openmetadata.service.monitoring.EventMonitorFactory;
import org.openmetadata.service.monitoring.EventMonitorPublisher;
import org.openmetadata.service.resources.CollectionRegistry;
import org.openmetadata.service.resources.databases.DatasourceConfig;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.SecretsManagerUpdateService;
import org.openmetadata.service.secrets.masker.EntityMaskerFactory;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.NoopAuthorizer;
import org.openmetadata.service.security.NoopFilter;
import org.openmetadata.service.security.auth.AuthenticatorHandler;
import org.openmetadata.service.security.auth.BasicAuthenticator;
import org.openmetadata.service.security.auth.LdapAuthenticator;
import org.openmetadata.service.security.auth.NoopAuthenticator;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.security.saml.OMMicrometerHttpFilter;
import org.openmetadata.service.security.saml.SamlAssertionConsumerServlet;
import org.openmetadata.service.security.saml.SamlLoginServlet;
import org.openmetadata.service.security.saml.SamlMetadataServlet;
import org.openmetadata.service.security.saml.SamlSettingsHolder;
import org.openmetadata.service.socket.FeedServlet;
import org.openmetadata.service.socket.OpenMetadataAssetServlet;
import org.openmetadata.service.socket.SocketAddressFilter;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.MicrometerBundleSingleton;
import org.openmetadata.service.util.incidentSeverityClassifier.IncidentSeverityClassifierInterface;
import org.openmetadata.service.util.jdbi.DatabaseAuthenticationProviderFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataApplication
extends Application<OpenMetadataApplicationConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadataApplication.class);
    private Authorizer authorizer;
    private AuthenticatorHandler authenticatorHandler;

    public void run(OpenMetadataApplicationConfig catalogConfig, Environment environment) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, IOException, ConfigurationException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.validateConfiguration(catalogConfig);
        IncidentSeverityClassifierInterface.createInstance(catalogConfig.getDataQualityConfiguration());
        DatasourceConfig.initialize(catalogConfig.getDataSourceFactory().getDriverClass());
        Jdbi jdbi = this.createAndSetupJDBI(environment, catalogConfig.getDataSourceFactory());
        CollectionDAO collectionDAO = (CollectionDAO)jdbi.onDemand(CollectionDAO.class);
        Entity.setCollectionDAO(collectionDAO);
        new SearchRepository(catalogConfig.getElasticSearchConfiguration());
        Entity.initializeRepositories(catalogConfig, jdbi);
        SettingsCache.initialize(catalogConfig);
        Fernet.getInstance().setFernetKey(catalogConfig);
        SecretsManager secretsManager = SecretsManagerFactory.createSecretsManager(catalogConfig.getSecretsManagerConfiguration(), catalogConfig.getClusterName());
        EntityMaskerFactory.createEntityMasker();
        JWTTokenGenerator.getInstance().init(catalogConfig.getJwtTokenConfiguration());
        ((SqlObjects)jdbi.getConfig(SqlObjects.class)).setSqlLocator((SqlLocator)new ConnectionAwareAnnotationSqlLocator(catalogConfig.getDataSourceFactory().getDriverClass()));
        this.validateMigrations(jdbi, catalogConfig);
        this.registerAuthorizer(catalogConfig, environment);
        this.registerAuthenticator(catalogConfig);
        ((DefaultServerFactory)catalogConfig.getServerFactory()).setRegisterDefaultExceptionMappers(Boolean.valueOf(false));
        environment.jersey().property("jersey.config.server.response.setStatusOverSendError", (Object)true);
        environment.jersey().register(MultiPartFeature.class);
        environment.jersey().register(CatalogGenericExceptionMapper.class);
        environment.jersey().register((Object)new ConstraintViolationExceptionMapper());
        environment.jersey().register((Object)new LoggingExceptionMapper<Throwable>(){});
        environment.jersey().register((Object)new JsonProcessingExceptionMapper(true));
        environment.jersey().register((Object)new EarlyEofExceptionMapper());
        environment.jersey().register(JsonMappingExceptionMapper.class);
        environment.healthChecks().register("OpenMetadataServerHealthCheck", (HealthCheck)new OpenMetadataServerHealthCheck());
        EventPubSub.start();
        this.registerResources(catalogConfig, environment, jdbi);
        this.registerEventFilter(catalogConfig, environment);
        environment.lifecycle().manage((Managed)new ManagedShutdown());
        this.registerEventPublisher(catalogConfig);
        new SecretsManagerUpdateService(secretsManager, catalogConfig.getClusterName()).updateEntities();
        this.authorizer.init(catalogConfig);
        this.authenticatorHandler.init(catalogConfig);
        MicrometerBundleSingleton.setWebAnalyticsEvents(catalogConfig);
        FilterRegistration.Dynamic micrometerFilter = environment.servlets().addFilter("OMMicrometerHttpFilter", (Filter)new OMMicrometerHttpFilter());
        micrometerFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, catalogConfig.getEventMonitorConfiguration().getPathPattern());
        this.initializeWebsockets(catalogConfig, environment);
        this.registerSamlHandlers(catalogConfig, environment);
        OpenMetadataAssetServlet assetServlet = new OpenMetadataAssetServlet("/assets", "/", "index.html", catalogConfig.getWebConfiguration());
        String pathPattern = "/*";
        environment.servlets().addServlet("static", (Servlet)assetServlet).addMapping(new String[]{pathPattern});
        PipelineServiceStatusJobHandler pipelineServiceStatusJobHandler = PipelineServiceStatusJobHandler.create(catalogConfig.getPipelineServiceClientConfiguration(), catalogConfig.getClusterName());
        pipelineServiceStatusJobHandler.addPipelineServiceStatusJob();
    }

    private void registerSamlHandlers(OpenMetadataApplicationConfig catalogConfig, Environment environment) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (catalogConfig.getAuthenticationConfiguration() != null && catalogConfig.getAuthenticationConfiguration().getProvider().equals((Object)AuthProvider.SAML)) {
            SamlSettingsHolder.getInstance().initDefaultSettings(catalogConfig);
            ServletRegistration.Dynamic samlRedirectServlet = environment.servlets().addServlet("saml_login", (Servlet)new SamlLoginServlet());
            samlRedirectServlet.addMapping(new String[]{"/api/v1/saml/login"});
            ServletRegistration.Dynamic samlReceiverServlet = environment.servlets().addServlet("saml_acs", (Servlet)new SamlAssertionConsumerServlet());
            samlReceiverServlet.addMapping(new String[]{"/api/v1/saml/acs"});
            ServletRegistration.Dynamic samlMetadataServlet = environment.servlets().addServlet("saml_metadata", (Servlet)new SamlMetadataServlet());
            samlMetadataServlet.addMapping(new String[]{"/api/v1/saml/metadata"});
        }
    }

    private Jdbi createAndSetupJDBI(Environment environment, DataSourceFactory dbFactory) {
        DatabaseAuthenticationProviderFactory.get(dbFactory.getUrl()).ifPresent(databaseAuthenticationProvider -> {
            String token = databaseAuthenticationProvider.authenticate(dbFactory.getUrl(), dbFactory.getUser(), dbFactory.getPassword());
            dbFactory.setPassword(token);
        });
        Jdbi jdbi = new JdbiFactory().build(environment, (PooledDataSourceFactory)dbFactory, "database");
        SqlLogger sqlLogger = new SqlLogger(){

            public void logBeforeExecution(StatementContext context) {
                LOG.debug("sql {}, parameters {}", (Object)context.getRenderedSql(), (Object)context.getBinding());
            }

            public void logAfterExecution(StatementContext context) {
                LOG.debug("sql {}, parameters {}, timeTaken {} ms", new Object[]{context.getRenderedSql(), context.getBinding(), context.getElapsedTime(ChronoUnit.MILLIS)});
            }
        };
        if (LOG.isDebugEnabled()) {
            jdbi.setSqlLogger(sqlLogger);
        }
        ((SqlObjects)jdbi.getConfig(SqlObjects.class)).setSqlLocator((SqlLocator)new ConnectionAwareAnnotationSqlLocator(dbFactory.getDriverClass()));
        return jdbi;
    }

    public void initialize(Bootstrap<OpenMetadataApplicationConfig> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StringSubstitutor)new EnvironmentVariableSubstitutor(false)));
        bootstrap.addBundle((ConfiguredBundle)new SwaggerBundle<OpenMetadataApplicationConfig>(){

            protected SwaggerBundleConfiguration getSwaggerBundleConfiguration(OpenMetadataApplicationConfig catalogConfig) {
                return catalogConfig.getSwaggerBundleConfig();
            }
        });
        bootstrap.addBundle((ConfiguredBundle)new HealthCheckBundle<OpenMetadataApplicationConfig>(){

            protected HealthConfiguration getHealthConfiguration(OpenMetadataApplicationConfig configuration) {
                return configuration.getHealthConfiguration();
            }
        });
        bootstrap.addBundle((ConfiguredBundle)MicrometerBundleSingleton.getInstance());
        bootstrap.addBundle((ConfiguredBundle)new OMWebBundle<OpenMetadataApplicationConfig>(){

            @Override
            public OMWebConfiguration getWebConfiguration(OpenMetadataApplicationConfig configuration) {
                return configuration.getWebConfiguration();
            }
        });
        super.initialize(bootstrap);
    }

    private void validateMigrations(Jdbi jdbi, OpenMetadataApplicationConfig conf) throws IOException {
        LOG.info("Validating Flyway migrations");
        Optional<String> lastMigrated = Migration.lastMigrated(jdbi);
        String maxMigration = Migration.lastMigrationFile(conf.getMigrationConfiguration());
        if (lastMigrated.isEmpty()) {
            throw new IllegalStateException("Could not validate Flyway migrations in the database. Make sure you have run `./bootstrap/bootstrap_storage.sh migrate-all` at least once.");
        }
        if (lastMigrated.get().compareTo(maxMigration) < 0) {
            throw new IllegalStateException("There are pending migrations to be run on the database. Please backup your data and run `./bootstrap/bootstrap_storage.sh migrate-all`. You can find more information on upgrading OpenMetadata at https://docs.open-metadata.org/deployment/upgrade ");
        }
        LOG.info("Validating native migrations");
        ConnectionType connectionType = ConnectionType.from(conf.getDataSourceFactory().getDriverClass());
        MigrationWorkflow migrationWorkflow = new MigrationWorkflow(jdbi, conf.getMigrationConfiguration().getNativePath(), connectionType, conf.getMigrationConfiguration().getExtensionPath(), false);
        migrationWorkflow.loadMigrations();
        migrationWorkflow.validateMigrationsForServer();
    }

    private void validateConfiguration(OpenMetadataApplicationConfig catalogConfig) throws ConfigurationException {
        if (catalogConfig.getAuthorizerConfiguration().getBotPrincipals() != null) {
            throw new ConfigurationException("'botPrincipals' configuration is deprecated. Please remove it from 'openmetadata.yaml and restart the server");
        }
        if (catalogConfig.getPipelineServiceClientConfiguration().getAuthConfig() != null) {
            LOG.warn("'authProvider' and 'authConfig' from the 'pipelineServiceClientConfiguration' option are deprecated and will be removed in future releases.");
        }
    }

    private void registerAuthorizer(OpenMetadataApplicationConfig catalogConfig, Environment environment) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        AuthorizerConfiguration authorizerConf = catalogConfig.getAuthorizerConfiguration();
        AuthenticationConfiguration authenticationConfiguration = catalogConfig.getAuthenticationConfiguration();
        if (authorizerConf != null) {
            this.authorizer = Class.forName(authorizerConf.getClassName()).asSubclass(Authorizer.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            String filterClazzName = authorizerConf.getContainerRequestFilter();
            if (!StringUtils.isEmpty((CharSequence)filterClazzName)) {
                ContainerRequestFilter filter = Class.forName(filterClazzName).asSubclass(ContainerRequestFilter.class).getConstructor(AuthenticationConfiguration.class, AuthorizerConfiguration.class).newInstance(authenticationConfiguration, authorizerConf);
                LOG.info("Registering ContainerRequestFilter: {}", (Object)filter.getClass().getCanonicalName());
                environment.jersey().register((Object)filter);
            }
        } else {
            LOG.info("Authorizer config not set, setting noop authorizer");
            this.authorizer = new NoopAuthorizer();
            NoopFilter filter = new NoopFilter(authenticationConfiguration, null);
            environment.jersey().register((Object)filter);
        }
    }

    private void registerAuthenticator(OpenMetadataApplicationConfig catalogConfig) {
        AuthenticationConfiguration authenticationConfiguration = catalogConfig.getAuthenticationConfiguration();
        switch (authenticationConfiguration.getProvider()) {
            case BASIC: {
                this.authenticatorHandler = new BasicAuthenticator();
                break;
            }
            case LDAP: {
                this.authenticatorHandler = new LdapAuthenticator();
                break;
            }
            default: {
                this.authenticatorHandler = new NoopAuthenticator();
            }
        }
    }

    private void registerEventFilter(OpenMetadataApplicationConfig catalogConfig, Environment environment) {
        if (catalogConfig.getEventHandlerConfiguration() != null) {
            EventFilter eventFilter = new EventFilter(catalogConfig);
            environment.jersey().register((Object)eventFilter);
        }
    }

    private void registerEventPublisher(OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        if (openMetadataApplicationConfig.getEventMonitorConfiguration() != null) {
            EventMonitor eventMonitor = EventMonitorFactory.createEventMonitor(openMetadataApplicationConfig.getEventMonitorConfiguration(), openMetadataApplicationConfig.getClusterName());
            EventMonitorPublisher eventMonitorPublisher = new EventMonitorPublisher(openMetadataApplicationConfig.getEventMonitorConfiguration(), eventMonitor);
            EventPubSub.addEventHandler(eventMonitorPublisher);
        }
    }

    private void registerResources(OpenMetadataApplicationConfig config, Environment environment, Jdbi jdbi) {
        CollectionRegistry.initialize();
        CollectionRegistry.getInstance().registerResources(jdbi, environment, config, this.authorizer, this.authenticatorHandler);
        environment.jersey().register((Object)new JsonPatchProvider());
        OMErrorPageHandler eph = new OMErrorPageHandler(config.getWebConfiguration());
        eph.addErrorPage(Response.Status.NOT_FOUND.getStatusCode(), "/");
        environment.getApplicationContext().setErrorHandler((ErrorHandler)eph);
    }

    private void initializeWebsockets(OpenMetadataApplicationConfig catalogConfig, Environment environment) {
        String pathSpec = "/api/v1/push/feed/*";
        SocketAddressFilter socketAddressFilter = catalogConfig.getAuthorizerConfiguration() != null ? new SocketAddressFilter(catalogConfig.getAuthenticationConfiguration(), catalogConfig.getAuthorizerConfiguration()) : new SocketAddressFilter();
        EngineIoServerOptions eioOptions = EngineIoServerOptions.newFromDefault();
        eioOptions.setAllowedCorsOrigins(null);
        WebSocketManager.WebSocketManagerBuilder.build(eioOptions);
        environment.getApplicationContext().setContextPath("/");
        environment.getApplicationContext().addFilter(new FilterHolder((Filter)socketAddressFilter), pathSpec, EnumSet.of(DispatcherType.REQUEST));
        environment.getApplicationContext().addServlet(new ServletHolder((Servlet)new FeedServlet()), pathSpec);
        try {
            WebSocketUpgradeFilter.configure((ServletContextHandler)environment.getApplicationContext());
            NativeWebSocketServletContainerInitializer.configure((ServletContextHandler)environment.getApplicationContext(), (context, container) -> container.addMapping((PathSpec)new ServletPathSpec(pathSpec), (servletUpgradeRequest, servletUpgradeResponse) -> new JettyWebSocketHandler(WebSocketManager.getInstance().getEngineIoServer())));
        }
        catch (ServletException ex) {
            LOG.error("Websocket Upgrade Filter error : " + ex.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        OpenMetadataApplication openMetadataApplication = new OpenMetadataApplication();
        openMetadataApplication.run(args);
    }

    public static class ManagedShutdown
    implements Managed {
        public void start() {
            LOG.info("Starting the application");
        }

        public void stop() throws InterruptedException, SchedulerException {
            LOG.info("Cache with Id Stats {}", (Object)EntityRepository.CACHE_WITH_ID.stats());
            LOG.info("Cache with name Stats {}", (Object)EntityRepository.CACHE_WITH_NAME.stats());
            EventPubSub.shutdown();
            AppScheduler.shutDown();
            EventSubscriptionScheduler.shutDown();
            LOG.info("Stopping the application");
        }
    }
}

