/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.searchIndex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.app.AppRunType;
import org.openmetadata.schema.entity.app.FailureContext;
import org.openmetadata.schema.entity.app.SuccessContext;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.system.EventPublisherJob;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.Stats;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.apps.AbstractNativeApplication;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.search.elasticsearch.ElasticSearchDataInsightProcessor;
import org.openmetadata.service.search.elasticsearch.ElasticSearchEntitiesProcessor;
import org.openmetadata.service.search.elasticsearch.ElasticSearchIndexSink;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.search.opensearch.OpenSearchDataInsightProcessor;
import org.openmetadata.service.search.opensearch.OpenSearchEntitiesProcessor;
import org.openmetadata.service.search.opensearch.OpenSearchIndexSink;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.interfaces.Sink;
import org.openmetadata.service.workflows.searchIndex.PaginatedDataInsightSource;
import org.openmetadata.service.workflows.searchIndex.PaginatedEntitiesSource;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndexApp
extends AbstractNativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexApp.class);
    private static final String ALL = "all";
    private static final Set<String> ALL_ENTITIES = Set.of("table", "dashboard", "topic", "pipeline", "ingestionPipeline", "searchIndex", "user", "team", "glossary", "glossaryTerm", "mlmodel", "tag", "classification", "query", "container", "database", "databaseSchema", "testCase", "testSuite", "chart", "dashboardDataModel", "databaseService", "messagingService", "dashboardService", "pipelineService", "mlmodelService", "searchService", "entityReportData", "webAnalyticEntityViewReportData", "webAnalyticUserActivityReportData", "domain", "storedProcedure", "storageService");
    private final List<PaginatedEntitiesSource> paginatedEntitiesSources = new ArrayList<PaginatedEntitiesSource>();
    private final List<PaginatedDataInsightSource> paginatedDataInsightSources = new ArrayList<PaginatedDataInsightSource>();
    private Processor entityProcessor;
    private Processor dataInsightProcessor;
    private Sink searchIndexSink;
    EventPublisherJob jobData;
    private volatile boolean stopped = false;

    public SearchIndexApp(CollectionDAO collectionDAO, SearchRepository searchRepository) {
        super(collectionDAO, searchRepository);
    }

    @Override
    public void init(App app) {
        super.init(app);
        EventPublisherJob request = JsonUtils.convertValue(app.getAppConfiguration(), EventPublisherJob.class).withStats(new Stats());
        if (request.getEntities().contains(ALL)) {
            request.setEntities(ALL_ENTITIES);
        }
        int totalRecords = ReindexingUtil.getTotalRequestToProcess(request.getEntities(), this.collectionDAO);
        this.jobData = request;
        this.jobData.setStats(new Stats().withJobStats(new StepStats().withTotalRecords(Integer.valueOf(totalRecords)).withFailedRecords(Integer.valueOf(0)).withSuccessRecords(Integer.valueOf(0))));
        request.getEntities().forEach(entityType -> {
            if (!ReindexingUtil.isDataInsightIndex(entityType)) {
                List<String> fields = List.of("*");
                PaginatedEntitiesSource source = new PaginatedEntitiesSource((String)entityType, this.jobData.getBatchSize(), fields);
                if (!CommonUtil.nullOrEmpty((String)request.getAfterCursor())) {
                    source.setCursor(request.getAfterCursor());
                }
                this.paginatedEntitiesSources.add(source);
            } else {
                this.paginatedDataInsightSources.add(new PaginatedDataInsightSource(this.collectionDAO, (String)entityType, this.jobData.getBatchSize()));
            }
        });
        if (this.searchRepository.getSearchType().equals((Object)ElasticSearchConfiguration.SearchType.OPENSEARCH)) {
            this.entityProcessor = new OpenSearchEntitiesProcessor(totalRecords);
            this.dataInsightProcessor = new OpenSearchDataInsightProcessor(totalRecords);
            this.searchIndexSink = new OpenSearchIndexSink(this.searchRepository, totalRecords);
        } else {
            this.entityProcessor = new ElasticSearchEntitiesProcessor(totalRecords);
            this.dataInsightProcessor = new ElasticSearchDataInsightProcessor(totalRecords);
            this.searchIndexSink = new ElasticSearchIndexSink(this.searchRepository, totalRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startApp(JobExecutionContext jobExecutionContext) {
        try {
            LOG.info("Executing Reindexing Job with JobData : {}", (Object)this.jobData);
            this.jobData.setStatus(EventPublisherJob.Status.RUNNING);
            AppRunType runType = AppRunType.fromValue((String)((String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"triggerType")));
            if (runType.equals((Object)AppRunType.Scheduled)) {
                this.jobData.setRecreateIndex(Boolean.valueOf(false));
            }
            this.entitiesReIndex();
            this.dataInsightReindex();
            this.updateJobStatus();
        }
        catch (Exception ex) {
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.JOB).withMessage(String.format("Reindexing Job Has Encountered an Exception. %n Job Data: %s, %n  Stack : %s ", this.jobData.toString(), ExceptionUtils.getStackTrace((Throwable)ex)));
            LOG.error(indexingError.getMessage());
            this.jobData.setStatus(EventPublisherJob.Status.FAILED);
            this.jobData.setFailure(indexingError);
        }
        finally {
            jobExecutionContext.getJobDetail().getJobDataMap().put("AppRunStats", (Object)this.jobData.getStats());
            this.updateRecordToDb(jobExecutionContext);
            this.sendUpdates();
        }
    }

    public void updateRecordToDb(JobExecutionContext jobExecutionContext) {
        AppRunRecord appRecord = this.getJobRecord(jobExecutionContext);
        appRecord.setStatus(AppRunRecord.Status.fromValue((String)this.jobData.getStatus().value()));
        if (this.jobData.getFailure() != null) {
            appRecord.setFailureContext(new FailureContext().withAdditionalProperty("failure", (Object)this.jobData.getFailure()));
        }
        if (this.jobData.getStats() != null) {
            appRecord.setSuccessContext(new SuccessContext().withAdditionalProperty("stats", (Object)this.jobData.getStats()));
        }
        this.pushAppStatusUpdates(jobExecutionContext, appRecord, true);
    }

    private void entitiesReIndex() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (PaginatedEntitiesSource paginatedEntitiesSource : this.paginatedEntitiesSources) {
            this.reCreateIndexes(paginatedEntitiesSource.getEntityType());
            contextData.put("entityType", paginatedEntitiesSource.getEntityType());
            while (!this.stopped && !paginatedEntitiesSource.isDone()) {
                try {
                    Object resultList = paginatedEntitiesSource.readNext((Map)null);
                    if (((ResultList)resultList).getData().isEmpty()) continue;
                    this.searchIndexSink.write(this.entityProcessor.process(resultList, contextData), contextData);
                }
                catch (SearchIndexException rx) {
                    this.jobData.setFailure(rx.getIndexingError());
                }
            }
            this.updateStats(paginatedEntitiesSource.getEntityType(), paginatedEntitiesSource.getStats());
            this.sendUpdates();
        }
    }

    private void dataInsightReindex() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (PaginatedDataInsightSource paginatedDataInsightSource : this.paginatedDataInsightSources) {
            this.reCreateIndexes(paginatedDataInsightSource.getEntityType());
            contextData.put("entityType", paginatedDataInsightSource.getEntityType());
            while (!this.stopped && !paginatedDataInsightSource.isDone()) {
                try {
                    Object resultList = paginatedDataInsightSource.readNext((Map)null);
                    if (((ResultList)resultList).getData().isEmpty()) continue;
                    this.searchIndexSink.write(this.dataInsightProcessor.process(resultList, contextData), contextData);
                }
                catch (SearchIndexException ex) {
                    this.jobData.setFailure(ex.getIndexingError());
                }
            }
            this.updateStats(paginatedDataInsightSource.getEntityType(), paginatedDataInsightSource.getStats());
            this.sendUpdates();
        }
    }

    private void sendUpdates() {
        try {
            if (WebSocketManager.getInstance() != null) {
                WebSocketManager.getInstance().broadCastMessageToAll("jobStatus", JsonUtils.pojoToJson(this.jobData));
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to send updated stats with WebSocket", (Throwable)ex);
        }
    }

    public void updateStats(String entityType, StepStats currentEntityStats) {
        Stats jobDataStats = this.jobData.getStats();
        StepStats entityLevelStats = jobDataStats.getEntityStats();
        if (entityLevelStats == null) {
            entityLevelStats = new StepStats();
        }
        entityLevelStats.withAdditionalProperty(entityType, (Object)currentEntityStats);
        StepStats stats = this.jobData.getStats().getJobStats();
        if (stats == null) {
            stats = new StepStats().withTotalRecords(Integer.valueOf(ReindexingUtil.getTotalRequestToProcess(this.jobData.getEntities(), this.collectionDAO)));
        }
        ReindexingUtil.getUpdatedStats(stats, currentEntityStats.getSuccessRecords(), currentEntityStats.getFailedRecords());
        jobDataStats.setJobStats(stats);
        jobDataStats.setEntityStats(entityLevelStats);
        this.jobData.setStats(jobDataStats);
    }

    private void reCreateIndexes(String entityType) {
        if (Boolean.FALSE.equals(this.jobData.getRecreateIndex())) {
            return;
        }
        IndexMapping indexType = this.searchRepository.getIndexMapping(entityType);
        this.searchRepository.deleteIndex(indexType);
        this.searchRepository.createIndex(indexType);
    }

    private void updateJobStatus() {
        if (this.stopped) {
            this.jobData.setStatus(EventPublisherJob.Status.STOPPED);
        } else if (this.jobData.getFailure() != null) {
            this.jobData.setStatus(EventPublisherJob.Status.FAILED);
        } else {
            this.jobData.setStatus(EventPublisherJob.Status.COMPLETED);
        }
    }

    public void stopJob() {
        this.stopped = true;
    }

    public EventPublisherJob getJobData() {
        return this.jobData;
    }
}

