/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.util.ArrayList;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.apps.bundles.changeEvent.msteams.TeamsMessage;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.decorators.OutgoingMessage;
import org.openmetadata.service.util.EmailUtil;

public class MSTeamsMessageDecorator
implements MessageDecorator<TeamsMessage> {
    @Override
    public String getBold() {
        return "**%s**";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "**";
    }

    @Override
    public String getAddMarkerClose() {
        return "** ";
    }

    @Override
    public String getRemoveMarker() {
        return "~~";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "~~ ";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn, String additionalParams) {
        return String.format("[%s](/%s/%s%s)", fqn.trim(), EmailUtil.getSmtpSettings().getOpenMetadataUrl(), entityType, CommonUtil.nullOrEmpty((String)additionalParams) ? "" : String.format("/%s", additionalParams));
    }

    @Override
    public TeamsMessage buildEntityMessage(ChangeEvent event) {
        return this.getTeamMessage(this.createEntityMessage(event));
    }

    @Override
    public TeamsMessage buildThreadMessage(ChangeEvent event) {
        return this.getTeamMessage(this.createThreadMessage(event));
    }

    private TeamsMessage getTeamMessage(OutgoingMessage outgoingMessage) {
        if (!outgoingMessage.getMessages().isEmpty()) {
            TeamsMessage teamsMessage = new TeamsMessage();
            teamsMessage.setSummary("Change Event From OpenMetadata");
            TeamsMessage.Section teamsSections = new TeamsMessage.Section();
            teamsSections.setActivityTitle(outgoingMessage.getHeader());
            ArrayList<TeamsMessage.Section> attachmentList = new ArrayList<TeamsMessage.Section>();
            outgoingMessage.getMessages().forEach(m -> attachmentList.add(this.getTeamsSection(teamsSections.getActivityTitle(), (String)m)));
            teamsMessage.setSections(attachmentList);
            return teamsMessage;
        }
        throw new UnhandledServerException("No messages found for the event");
    }

    private TeamsMessage.Section getTeamsSection(String activityTitle, String message) {
        TeamsMessage.Section section = new TeamsMessage.Section();
        section.setActivityTitle(activityTitle);
        section.setActivityText(message);
        return section;
    }
}

