/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.google.common.collect.Streams;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.csv.CsvUtil;
import org.openmetadata.csv.EntityCsv;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.data.CreateTableProfile;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.feed.Suggestion;
import org.openmetadata.schema.tests.CustomMetric;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.ColumnJoin;
import org.openmetadata.schema.type.ColumnProfile;
import org.openmetadata.schema.type.ColumnProfilerConfig;
import org.openmetadata.schema.type.DailyCount;
import org.openmetadata.schema.type.DataModel;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.JoinedWith;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.SuggestionType;
import org.openmetadata.schema.type.SystemProfile;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TableData;
import org.openmetadata.schema.type.TableJoins;
import org.openmetadata.schema.type.TableProfile;
import org.openmetadata.schema.type.TableProfilerConfig;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.csv.CsvDocumentation;
import org.openmetadata.schema.type.csv.CsvFile;
import org.openmetadata.schema.type.csv.CsvHeader;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.mask.PIIMasker;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.LambdaExceptionUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRepository
extends EntityRepository<Table> {
    private static final Logger LOG = LoggerFactory.getLogger(TableRepository.class);
    static final String PATCH_FIELDS = "tableConstraints,tablePartition,columns";
    static final String UPDATE_FIELDS = "tableConstraints,tablePartition,dataModel,sourceUrl,columns";
    public static final String FIELD_RELATION_COLUMN_TYPE = "table.columns.column";
    public static final String FIELD_RELATION_TABLE_TYPE = "table";
    public static final String TABLE_PROFILE_EXTENSION = "table.tableProfile";
    public static final String SYSTEM_PROFILE_EXTENSION = "table.systemProfile";
    public static final String TABLE_COLUMN_PROFILE_EXTENSION = "table.columnProfile";
    public static final String TABLE_SAMPLE_DATA_EXTENSION = "table.sampleData";
    public static final String TABLE_PROFILER_CONFIG_EXTENSION = "table.tableProfilerConfig";
    public static final String TABLE_COLUMN_EXTENSION = "table.column";
    public static final String TABLE_EXTENSION = "table.table";
    public static final String CUSTOM_METRICS_EXTENSION = "customMetrics.";
    public static final String TABLE_PROFILER_CONFIG = "tableProfilerConfig";
    public static final String COLUMN_FIELD = "columns";
    public static final String CUSTOM_METRICS = "customMetrics";

    public TableRepository() {
        super("v1/tables/", FIELD_RELATION_TABLE_TYPE, Table.class, Entity.getCollectionDAO().tableDAO(), PATCH_FIELDS, UPDATE_FIELDS);
        this.supportsSearch = true;
    }

    @Override
    public void setFields(Table table, EntityUtil.Fields fields) {
        this.setDefaultFields(table);
        if (table.getUsageSummary() == null) {
            table.setUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), table.getId()) : table.getUsageSummary());
        }
        if (fields.contains(COLUMN_FIELD)) {
            Entity.populateEntityFieldTags(this.entityType, table.getColumns(), table.getFullyQualifiedName(), fields.contains("tags"));
        }
        table.setJoins(fields.contains("joins") ? this.getJoins(table) : table.getJoins());
        table.setTableProfilerConfig(fields.contains(TABLE_PROFILER_CONFIG) ? this.getTableProfilerConfig(table) : table.getTableProfilerConfig());
        table.setTestSuite(fields.contains("testSuite") ? this.getTestSuite(table) : table.getTestSuite());
        table.setCustomMetrics((List)(fields.contains(CUSTOM_METRICS) ? this.getCustomMetrics(table, null) : table.getCustomMetrics()));
        if (fields.contains(COLUMN_FIELD) && fields.contains(CUSTOM_METRICS)) {
            for (Column column : table.getColumns()) {
                column.setCustomMetrics(this.getCustomMetrics(table, column.getName()));
            }
        }
    }

    @Override
    public void clearFields(Table table, EntityUtil.Fields fields) {
        table.setTableConstraints(fields.contains("tableConstraints") ? table.getTableConstraints() : null);
        table.setUsageSummary(fields.contains("usageSummary") ? table.getUsageSummary() : null);
        table.setJoins(fields.contains("joins") ? table.getJoins() : null);
        table.setViewDefinition(fields.contains("viewDefinition") ? table.getViewDefinition() : null);
        table.setTableProfilerConfig(fields.contains(TABLE_PROFILER_CONFIG) ? table.getTableProfilerConfig() : null);
        table.setTestSuite(fields.contains("testSuite") ? table.getTestSuite() : null);
    }

    @Override
    public void setInheritedFields(Table table, EntityUtil.Fields fields) {
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity("databaseSchema", table.getDatabaseSchema().getId(), "owner,domain", Include.ALL);
        this.inheritOwner(table, fields, (EntityInterface)schema);
        this.inheritDomain(table, fields, (EntityInterface)schema);
        table.withRetentionPeriod(table.getRetentionPeriod() == null ? schema.getRetentionPeriod() : table.getRetentionPeriod());
    }

    private void setDefaultFields(Table table) {
        EntityReference schemaRef = this.getContainer(table.getId(), "databaseSchema");
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity(schemaRef, "", Include.ALL);
        table.withDatabaseSchema(schemaRef).withDatabase(schema.getDatabase()).withService(schema.getService());
    }

    @Override
    public void restorePatchAttributes(Table original, Table updated) {
        super.restorePatchAttributes(original, updated);
        updated.withDatabase(original.getDatabase()).withService(original.getService());
    }

    @Override
    public void setFullyQualifiedName(Table table) {
        table.setFullyQualifiedName(FullyQualifiedName.add(table.getDatabaseSchema().getFullyQualifiedName(), table.getName()));
        ColumnUtil.setColumnFQN(table.getFullyQualifiedName(), table.getColumns());
    }

    @Transaction
    public Table addJoins(UUID tableId, TableJoins joins) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        if (!CommonUtil.dateInRange((DateFormat)RestUtil.DATE_FORMAT, (String)joins.getStartDate(), (int)0, (int)30)) {
            throw new IllegalArgumentException("Date range can only include past 30 days starting today");
        }
        for (ColumnJoin join : joins.getColumnJoins()) {
            TableRepository.validateColumn(table, join.getColumnName());
            this.validateColumnFQNs(join.getJoinedWith());
        }
        for (ColumnJoin join : joins.getDirectTableJoins()) {
            this.validateTableFQN(join.getFullyQualifiedName());
        }
        for (ColumnJoin join : joins.getColumnJoins()) {
            String columnFQN = FullyQualifiedName.add(table.getFullyQualifiedName(), join.getColumnName());
            this.addJoinedWith(joins.getStartDate(), columnFQN, FIELD_RELATION_COLUMN_TYPE, join.getJoinedWith());
        }
        this.addJoinedWith(joins.getStartDate(), table.getFullyQualifiedName(), FIELD_RELATION_TABLE_TYPE, joins.getDirectTableJoins());
        return table.withJoins(this.getJoins(table));
    }

    @Transaction
    public Table addSampleData(UUID tableId, TableData tableData) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        for (String columnName : tableData.getColumns()) {
            TableRepository.validateColumn(table, columnName);
        }
        for (List row : tableData.getRows()) {
            if (row.size() == tableData.getColumns().size()) continue;
            throw new IllegalArgumentException(String.format("Number of columns is %d but row has %d sample values", tableData.getColumns().size(), row.size()));
        }
        this.daoCollection.entityExtensionDAO().insert(tableId, TABLE_SAMPLE_DATA_EXTENSION, "tableData", JsonUtils.pojoToJson(tableData));
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table.withSampleData(tableData);
    }

    public Table getSampleData(UUID tableId, boolean authorizePII) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        TableData sampleData = JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(table.getId(), TABLE_SAMPLE_DATA_EXTENSION), TableData.class);
        table.setSampleData(sampleData);
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        if (!authorizePII) {
            Entity.populateEntityFieldTags(this.entityType, table.getColumns(), table.getFullyQualifiedName(), true);
            table.setTags(this.getTags(table));
            return PIIMasker.getSampleData(table);
        }
        return table;
    }

    @Transaction
    public Table deleteSampleData(UUID tableId) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        this.daoCollection.entityExtensionDAO().delete(tableId, TABLE_SAMPLE_DATA_EXTENSION);
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table;
    }

    public TableProfilerConfig getTableProfilerConfig(Table table) {
        return JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(table.getId(), TABLE_PROFILER_CONFIG_EXTENSION), TableProfilerConfig.class);
    }

    public TestSuite getTestSuite(Table table) {
        List<CollectionDAO.EntityRelationshipRecord> entityRelationshipRecords = this.daoCollection.relationshipDAO().findTo(table.getId(), FIELD_RELATION_TABLE_TYPE, Relationship.CONTAINS.ordinal());
        Optional<CollectionDAO.EntityRelationshipRecord> testSuiteRelationshipRecord = entityRelationshipRecords.stream().filter(entityRelationshipRecord -> entityRelationshipRecord.getType().equals("testSuite")).findFirst();
        return testSuiteRelationshipRecord.map(entityRelationshipRecord -> (TestSuite)Entity.getEntity("testSuite", entityRelationshipRecord.getId(), "*", Include.ALL)).orElse(null);
    }

    @Transaction
    public Table addTableProfilerConfig(UUID tableId, TableProfilerConfig tableProfilerConfig) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        if (tableProfilerConfig.getExcludeColumns() != null) {
            for (String columnName : tableProfilerConfig.getExcludeColumns()) {
                TableRepository.validateColumn(table, columnName);
            }
        }
        if (tableProfilerConfig.getIncludeColumns() != null) {
            for (ColumnProfilerConfig columnProfilerConfig : tableProfilerConfig.getIncludeColumns()) {
                TableRepository.validateColumn(table, columnProfilerConfig.getColumnName());
            }
        }
        if (tableProfilerConfig.getProfileSampleType() != null && tableProfilerConfig.getProfileSample() != null) {
            EntityUtil.validateProfileSample(tableProfilerConfig.getProfileSampleType().toString(), tableProfilerConfig.getProfileSample());
        }
        this.daoCollection.entityExtensionDAO().insert(tableId, TABLE_PROFILER_CONFIG_EXTENSION, TABLE_PROFILER_CONFIG, JsonUtils.pojoToJson(tableProfilerConfig));
        this.clearFields(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table.withTableProfilerConfig(tableProfilerConfig);
    }

    @Transaction
    public Table deleteTableProfilerConfig(UUID tableId) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        this.daoCollection.entityExtensionDAO().delete(tableId, TABLE_PROFILER_CONFIG_EXTENSION);
        this.clearFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table;
    }

    private Column getColumnNameForProfiler(List<Column> columnList, ColumnProfile columnProfile, String parentName) {
        for (Column col : columnList) {
            Column childColumn;
            String columnName = parentName != null ? String.format("%s.%s", parentName, col.getName()) : col.getName();
            if (columnName.equals(columnProfile.getName())) {
                return col;
            }
            if (col.getChildren() == null || (childColumn = this.getColumnNameForProfiler(col.getChildren(), columnProfile, columnName)) == null) continue;
            return childColumn;
        }
        return null;
    }

    public Table addTableProfileData(UUID tableId, CreateTableProfile createTableProfile) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        this.daoCollection.profilerDataTimeSeriesDao().insert(table.getFullyQualifiedName(), TABLE_PROFILE_EXTENSION, "tableProfile", JsonUtils.pojoToJson(createTableProfile.getTableProfile()));
        for (ColumnProfile columnProfile : createTableProfile.getColumnProfile()) {
            Column column = this.getColumnNameForProfiler(table.getColumns(), columnProfile, null);
            if (column == null) {
                throw new IllegalArgumentException("Invalid column name " + columnProfile.getName());
            }
            this.daoCollection.profilerDataTimeSeriesDao().insert(column.getFullyQualifiedName(), TABLE_COLUMN_PROFILE_EXTENSION, "columnProfile", JsonUtils.pojoToJson(columnProfile));
        }
        List systemProfiles = createTableProfile.getSystemProfile();
        if (systemProfiles != null && !systemProfiles.isEmpty()) {
            for (SystemProfile systemProfile : createTableProfile.getSystemProfile()) {
                String storedSystemProfile = this.daoCollection.profilerDataTimeSeriesDao().getExtensionAtTimestampWithOperation(table.getFullyQualifiedName(), SYSTEM_PROFILE_EXTENSION, systemProfile.getTimestamp(), systemProfile.getOperation().value());
                this.daoCollection.profilerDataTimeSeriesDao().storeTimeSeriesWithOperation(table.getFullyQualifiedName(), SYSTEM_PROFILE_EXTENSION, "systemProfile", JsonUtils.pojoToJson(systemProfile), systemProfile.getTimestamp(), systemProfile.getOperation().value(), storedSystemProfile != null);
            }
        }
        this.setFieldsInternal(table, EntityUtil.Fields.EMPTY_FIELDS);
        return table.withProfile(createTableProfile.getTableProfile());
    }

    public void deleteTableProfile(String fqn, String entityType, Long timestamp) {
        String extension;
        if (entityType.equalsIgnoreCase(FIELD_RELATION_TABLE_TYPE)) {
            extension = TABLE_PROFILE_EXTENSION;
        } else if (entityType.equalsIgnoreCase("column")) {
            extension = TABLE_COLUMN_PROFILE_EXTENSION;
        } else if (entityType.equalsIgnoreCase("system")) {
            extension = SYSTEM_PROFILE_EXTENSION;
        } else {
            throw new IllegalArgumentException("entityType must be table, column or system");
        }
        this.daoCollection.profilerDataTimeSeriesDao().deleteAtTimestamp(fqn, extension, timestamp);
    }

    public ResultList<TableProfile> getTableProfiles(String fqn, Long startTs, Long endTs) {
        List<TableProfile> tableProfiles = JsonUtils.readObjects(this.daoCollection.profilerDataTimeSeriesDao().listBetweenTimestampsByOrder(fqn, TABLE_PROFILE_EXTENSION, startTs, endTs, EntityTimeSeriesDAO.OrderBy.DESC), TableProfile.class);
        return new ResultList<TableProfile>(tableProfiles, startTs.toString(), endTs.toString(), tableProfiles.size());
    }

    public ResultList<ColumnProfile> getColumnProfiles(String fqn, Long startTs, Long endTs) {
        List<ColumnProfile> columnProfiles = JsonUtils.readObjects(this.daoCollection.profilerDataTimeSeriesDao().listBetweenTimestampsByOrder(fqn, TABLE_COLUMN_PROFILE_EXTENSION, startTs, endTs, EntityTimeSeriesDAO.OrderBy.DESC), ColumnProfile.class);
        return new ResultList<ColumnProfile>(columnProfiles, startTs.toString(), endTs.toString(), columnProfiles.size());
    }

    public ResultList<SystemProfile> getSystemProfiles(String fqn, Long startTs, Long endTs) {
        List<SystemProfile> systemProfiles = JsonUtils.readObjects(this.daoCollection.profilerDataTimeSeriesDao().listBetweenTimestampsByOrder(fqn, SYSTEM_PROFILE_EXTENSION, startTs, endTs, EntityTimeSeriesDAO.OrderBy.DESC), SystemProfile.class);
        return new ResultList<SystemProfile>(systemProfiles, startTs.toString(), endTs.toString(), systemProfiles.size());
    }

    private void setColumnProfile(List<Column> columnList) {
        for (Column column : columnList) {
            ColumnProfile columnProfile = JsonUtils.readValue(this.daoCollection.profilerDataTimeSeriesDao().getLatestExtension(column.getFullyQualifiedName(), TABLE_COLUMN_PROFILE_EXTENSION), ColumnProfile.class);
            column.setProfile(columnProfile);
            if (column.getChildren() == null) continue;
            this.setColumnProfile(column.getChildren());
        }
    }

    public Table getLatestTableProfile(String fqn, boolean authorizePII) {
        Table table = (Table)this.findByName(fqn, Include.ALL);
        TableProfile tableProfile = JsonUtils.readValue(this.daoCollection.profilerDataTimeSeriesDao().getLatestExtension(table.getFullyQualifiedName(), TABLE_PROFILE_EXTENSION), TableProfile.class);
        table.setProfile(tableProfile);
        this.setColumnProfile(table.getColumns());
        if (!authorizePII) {
            Entity.populateEntityFieldTags(this.entityType, table.getColumns(), table.getFullyQualifiedName(), true);
            return PIIMasker.getTableProfile(table);
        }
        return table;
    }

    public Table addCustomMetric(UUID tableId, CustomMetric customMetric) {
        CustomMetric storedCustomMetrics;
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        String customMetricName = customMetric.getName();
        String customMetricColumnName = customMetric.getColumnName();
        String extensionType = customMetricColumnName != null ? TABLE_COLUMN_EXTENSION : TABLE_EXTENSION;
        String extension = CUSTOM_METRICS_EXTENSION + extensionType + "." + customMetricName;
        if (customMetricColumnName != null) {
            TableRepository.validateColumn(table, customMetricColumnName);
        }
        if ((storedCustomMetrics = this.getCustomMetric(table, extension)) != null) {
            storedCustomMetrics.setExpression(customMetric.getExpression());
        }
        this.daoCollection.entityExtensionDAO().insert(table.getId(), extension, "customMetric", JsonUtils.pojoToJson(customMetric));
        this.setFieldsInternal(table, new EntityUtil.Fields(Set.of(CUSTOM_METRICS, COLUMN_FIELD)));
        return table;
    }

    public Table deleteCustomMetric(UUID tableId, String columnName, String metricName) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        if (columnName != null) {
            TableRepository.validateColumn(table, columnName);
        }
        String extensionType = columnName != null ? TABLE_COLUMN_EXTENSION : TABLE_EXTENSION;
        String extension = CUSTOM_METRICS_EXTENSION + extensionType + "." + metricName;
        this.daoCollection.entityExtensionDAO().delete(tableId, extension);
        this.setFieldsInternal(table, new EntityUtil.Fields(Set.of(CUSTOM_METRICS, COLUMN_FIELD)));
        return table;
    }

    public Table addDataModel(UUID tableId, DataModel dataModel) {
        Table table = (Table)this.find(tableId, Include.NON_DELETED);
        if ((dataModel.getRawSql() == null || dataModel.getRawSql().isBlank()) && table.getDataModel() != null && table.getDataModel().getRawSql() != null && !table.getDataModel().getRawSql().isBlank()) {
            dataModel.setRawSql(table.getDataModel().getRawSql());
        }
        if (!(dataModel.getSql() != null && !dataModel.getSql().isBlank() || table.getDataModel() == null || table.getDataModel().getSql() == null && table.getDataModel().getSql().isBlank())) {
            dataModel.setSql(table.getDataModel().getSql());
        }
        table.withDataModel(dataModel);
        if (table.getOwner() == null) {
            this.storeOwner(table, dataModel.getOwner());
        }
        table.setTags(dataModel.getTags());
        this.applyTags(table);
        for (Column modelColumn : CommonUtil.listOrEmpty((List)dataModel.getColumns())) {
            Column stored = table.getColumns().stream().filter(c -> EntityUtil.columnNameMatch.test((Column)c, modelColumn)).findAny().orElse(null);
            if (stored == null) continue;
            stored.setTags(modelColumn.getTags());
        }
        this.applyColumnTags(table.getColumns());
        this.dao.update(table.getId(), table.getFullyQualifiedName(), JsonUtils.pojoToJson(table));
        this.setFieldsInternal(table, new EntityUtil.Fields(Set.of("owner"), "owner"));
        this.setFieldsInternal(table, new EntityUtil.Fields(Set.of("tags"), "tags"));
        return table;
    }

    @Override
    public void prepare(Table table, boolean update) {
        DatabaseSchema schema = (DatabaseSchema)Entity.getEntity(table.getDatabaseSchema(), "", Include.ALL);
        table.withDatabaseSchema(schema.getEntityReference()).withDatabase(schema.getDatabase()).withService(schema.getService()).withServiceType(schema.getServiceType());
    }

    @Override
    public void storeEntity(Table table, boolean update) {
        EntityReference service = table.getService();
        table.withService(null);
        List columnWithTags = table.getColumns();
        table.setColumns(ColumnUtil.cloneWithoutTags(columnWithTags));
        table.getColumns().forEach(column -> column.setTags(null));
        this.store(table, update);
        table.withColumns(columnWithTags).withService(service);
    }

    @Override
    public void storeRelationships(Table table) {
        this.addRelationship(table.getDatabaseSchema().getId(), table.getId(), "databaseSchema", FIELD_RELATION_TABLE_TYPE, Relationship.CONTAINS);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Table original, Table updated, EntityRepository.Operation operation) {
        return new TableUpdater(original, updated, operation);
    }

    @Override
    public void applyTags(Table table) {
        super.applyTags(table);
        this.applyColumnTags(table.getColumns());
    }

    @Override
    public EntityInterface getParentEntity(Table entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getDatabaseSchema(), fields, Include.NON_DELETED);
    }

    @Override
    public void validateTags(Table entity) {
        super.validateTags(entity);
        this.validateColumnTags(entity.getColumns());
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Table table = (Table)entity;
        EntityUtil.mergeTags(allTags, table.getTags());
        table.getColumns().forEach(column -> EntityUtil.mergeTags(allTags, column.getTags()));
        if (table.getDataModel() != null) {
            EntityUtil.mergeTags(allTags, table.getDataModel().getTags());
            for (Column column2 : CommonUtil.listOrEmpty((List)table.getDataModel().getColumns())) {
                EntityUtil.mergeTags(allTags, column2.getTags());
            }
        }
        return allTags;
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals(COLUMN_FIELD)) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (EntityUtil.isDescriptionTask(taskType)) {
                return new ColumnDescriptionWorkflow(threadContext);
            }
            if (EntityUtil.isTagTask(taskType)) {
                return new ColumnTagWorkflow(threadContext);
            }
            throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    public Table applySuggestion(EntityInterface entity, String columnFQN, Suggestion suggestion) {
        Table table = (Table)Entity.getEntity(FIELD_RELATION_TABLE_TYPE, entity.getId(), "columns,tags", Include.ALL);
        for (Column col : table.getColumns()) {
            if (!col.getFullyQualifiedName().equals(columnFQN)) continue;
            if (suggestion.getType().equals((Object)SuggestionType.SuggestTagLabel)) {
                ArrayList tags = new ArrayList(col.getTags());
                tags.addAll(suggestion.getTagLabels());
                col.setTags(tags);
                continue;
            }
            if (suggestion.getType().equals((Object)SuggestionType.SuggestDescription)) {
                col.setDescription(suggestion.getDescription());
                continue;
            }
            throw new WebApplicationException("Invalid suggestion Type");
        }
        return table;
    }

    @Override
    public String exportToCsv(String name, String user) throws IOException {
        Table table = (Table)this.getByName(null, name, new EntityUtil.Fields((Set<String>)this.allowedFields, "owner,domain,tags,columns"));
        return new TableCsv(table, user).exportCsv(CommonUtil.listOf((Object[])new Table[]{table}));
    }

    @Override
    public CsvImportResult importFromCsv(String name, String csv, boolean dryRun, String user) throws IOException {
        Table table = (Table)this.getByName(null, name, new EntityUtil.Fields((Set<String>)this.allowedFields, "owner,domain,tags,columns"));
        return new TableCsv(table, user).importCsv(csv, dryRun);
    }

    private static Column getColumn(Table table, String columnName) {
        String childrenName = "";
        if (columnName.contains(".")) {
            String fieldNameWithoutQuotes = columnName.substring(1, columnName.length() - 1);
            columnName = fieldNameWithoutQuotes.substring(0, fieldNameWithoutQuotes.indexOf("."));
            childrenName = fieldNameWithoutQuotes.substring(fieldNameWithoutQuotes.lastIndexOf(".") + 1);
        }
        Column column = EntityUtil.findColumn(table.getColumns(), columnName);
        if (!childrenName.isEmpty() && column != null) {
            column = TableRepository.getChildColumn(column.getChildren(), childrenName);
        }
        if (column == null) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("column", columnName));
        }
        return column;
    }

    private static Column getChildColumn(List<Column> column, String childrenName) {
        Column childrenColumn;
        block2: {
            childrenColumn = null;
            for (Column col : column) {
                if (!col.getName().equals(childrenName)) continue;
                childrenColumn = col;
                break;
            }
            if (childrenColumn != null) break block2;
            for (Column value : column) {
                if (value.getChildren() != null && (childrenColumn = TableRepository.getChildColumn(value.getChildren(), childrenName)) != null) break;
            }
        }
        return childrenColumn;
    }

    private void validateTableFQN(String fqn) {
        try {
            this.dao.existsByName(fqn);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalArgumentException("Invalid table name " + fqn, (Throwable)((Object)e));
        }
    }

    public static void validateColumn(Table table, String columnName) {
        boolean validColumn = table.getColumns().stream().anyMatch(col -> col.getName().equals(columnName));
        if (!validColumn) {
            throw new IllegalArgumentException("Invalid column name " + columnName);
        }
    }

    private void validateColumnFQNs(List<JoinedWith> joinedWithList) {
        for (JoinedWith joinedWith : joinedWithList) {
            String tableFQN = FullyQualifiedName.getTableFQN(joinedWith.getFullyQualifiedName());
            Table joinedWithTable = (Table)this.findByName(tableFQN, Include.NON_DELETED);
            ColumnUtil.validateColumnFQN(joinedWithTable.getColumns(), joinedWith.getFullyQualifiedName());
        }
    }

    private void addJoinedWith(String date, String entityFQN, String entityRelationType, List<JoinedWith> joinedWithList) {
        for (JoinedWith joinedWith : joinedWithList) {
            String toEntityFQN;
            String fromEntityFQN;
            if (entityFQN.compareTo(joinedWith.getFullyQualifiedName()) < 0) {
                fromEntityFQN = entityFQN;
                toEntityFQN = joinedWith.getFullyQualifiedName();
            } else {
                fromEntityFQN = joinedWith.getFullyQualifiedName();
                toEntityFQN = entityFQN;
            }
            List<DailyCount> currentDailyCounts = Optional.ofNullable(this.daoCollection.fieldRelationshipDAO().find(fromEntityFQN, toEntityFQN, entityRelationType, entityRelationType, Relationship.JOINED_WITH.ordinal())).map(LambdaExceptionUtil.rethrowFunction(j -> JsonUtils.readObjects(j, DailyCount.class))).orElse(List.of());
            DailyCount receivedDailyCount = new DailyCount().withCount(joinedWith.getJoinCount()).withDate(date);
            List<DailyCount> newDailyCounts = this.aggregateAndFilterDailyCounts(currentDailyCounts, receivedDailyCount);
            this.daoCollection.fieldRelationshipDAO().upsert(fromEntityFQN, toEntityFQN, fromEntityFQN, toEntityFQN, entityRelationType, entityRelationType, Relationship.JOINED_WITH.ordinal(), "dailyCount", JsonUtils.pojoToJson(newDailyCounts));
        }
    }

    private List<DailyCount> aggregateAndFilterDailyCounts(List<DailyCount> currentDailyCounts, DailyCount newDailyCount) {
        Map<String, List<DailyCount>> joinCountByDay = Streams.concat((Stream[])new Stream[]{currentDailyCounts.stream(), Stream.of(newDailyCount)}).collect(Collectors.groupingBy(DailyCount::getDate));
        return joinCountByDay.entrySet().stream().map(e -> {
            if (((String)e.getKey()).equals(newDailyCount.getDate())) {
                return newDailyCount;
            }
            return new DailyCount().withDate((String)e.getKey()).withCount(((DailyCount)((List)e.getValue()).stream().findFirst().orElseThrow(() -> new IllegalStateException("Collector.groupingBy created an empty grouping"))).getCount());
        }).filter(this.inLast30Days()).sorted(LambdaExceptionUtil.ignoringComparator((dc1, dc2) -> RestUtil.compareDates(dc1.getDate(), dc2.getDate()))).collect(Collectors.toList());
    }

    private TableJoins getJoins(Table table) {
        String today = RestUtil.DATE_FORMAT.format(new Date());
        String todayMinus30Days = CommonUtil.getDateStringByOffset((DateFormat)RestUtil.DATE_FORMAT, (String)today, (int)-30);
        return new TableJoins().withStartDate(todayMinus30Days).withDayCount(Integer.valueOf(30)).withColumnJoins(this.getColumnJoins(table)).withDirectTableJoins(this.getDirectTableJoins(table));
    }

    private List<JoinedWith> getDirectTableJoins(Table table) {
        List<Pair> entityRelations = this.daoCollection.fieldRelationshipDAO().listBidirectional(table.getFullyQualifiedName(), FIELD_RELATION_TABLE_TYPE, FIELD_RELATION_TABLE_TYPE, Relationship.JOINED_WITH.ordinal()).stream().map(LambdaExceptionUtil.rethrowFunction(er -> Pair.of((Object)((String)er.getMiddle()), JsonUtils.readObjects((String)er.getRight(), DailyCount.class)))).toList();
        return entityRelations.stream().map(er -> new JoinedWith().withFullyQualifiedName((String)er.getLeft()).withJoinCount(Integer.valueOf(((List)er.getRight()).stream().filter(this.inLast30Days()).mapToInt(DailyCount::getCount).sum()))).collect(Collectors.toList());
    }

    private List<ColumnJoin> getColumnJoins(Table table) {
        List<Triple> entityRelations = this.daoCollection.fieldRelationshipDAO().listBidirectionalByPrefix(table.getFullyQualifiedName(), FIELD_RELATION_COLUMN_TYPE, FIELD_RELATION_COLUMN_TYPE, Relationship.JOINED_WITH.ordinal()).stream().map(LambdaExceptionUtil.rethrowFunction(er -> Triple.of((Object)FullyQualifiedName.getColumnName((String)er.getLeft()), (Object)((String)er.getMiddle()), JsonUtils.readObjects((String)er.getRight(), DailyCount.class)))).toList();
        return entityRelations.stream().collect(Collectors.groupingBy(Triple::getLeft)).entrySet().stream().map(e -> new ColumnJoin().withColumnName((String)e.getKey()).withJoinedWith(((List)e.getValue()).stream().map(er -> new JoinedWith().withFullyQualifiedName((String)er.getMiddle()).withJoinCount(Integer.valueOf(((List)er.getRight()).stream().filter(this.inLast30Days()).mapToInt(DailyCount::getCount).sum()))).toList())).toList();
    }

    private Predicate<DailyCount> inLast30Days() {
        return dc -> CommonUtil.dateInRange((DateFormat)RestUtil.DATE_FORMAT, (String)dc.getDate(), (int)0, (int)30);
    }

    private CustomMetric getCustomMetric(Table table, String extension) {
        return JsonUtils.readValue(this.daoCollection.entityExtensionDAO().getExtension(table.getId(), extension), CustomMetric.class);
    }

    private List<CustomMetric> getCustomMetrics(Table table, String columnName) {
        Object extension = columnName != null ? TABLE_COLUMN_EXTENSION : TABLE_EXTENSION;
        extension = CUSTOM_METRICS_EXTENSION + (String)extension;
        List<CollectionDAO.ExtensionRecord> extensionRecords = this.daoCollection.entityExtensionDAO().getExtensions(table.getId(), (String)extension);
        List<Object> customMetrics = new ArrayList<CustomMetric>();
        for (CollectionDAO.ExtensionRecord extensionRecord : extensionRecords) {
            customMetrics.add(JsonUtils.readValue(extensionRecord.extensionJson(), CustomMetric.class));
        }
        if (columnName != null) {
            customMetrics = customMetrics.stream().filter(metric -> metric.getColumnName().equals(columnName)).collect(Collectors.toList());
        }
        return customMetrics;
    }

    public class TableUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public TableUpdater(Table original, Table updated, EntityRepository.Operation operation) {
            super((EntityRepository)TableRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            Table origTable = (Table)this.original;
            Table updatedTable = (Table)this.updated;
            DatabaseUtil.validateColumns(updatedTable.getColumns());
            this.recordChange("tableType", origTable.getTableType(), updatedTable.getTableType());
            this.updateConstraints(origTable, updatedTable);
            this.updateColumns(TableRepository.COLUMN_FIELD, origTable.getColumns(), ((Table)this.updated).getColumns(), (BiPredicate)EntityUtil.columnMatch);
            this.recordChange("sourceUrl", ((Table)this.original).getSourceUrl(), ((Table)this.updated).getSourceUrl());
            this.recordChange("retentionPeriod", ((Table)this.original).getRetentionPeriod(), ((Table)this.updated).getRetentionPeriod());
            this.recordChange("sourceHash", ((Table)this.original).getSourceHash(), ((Table)this.updated).getSourceHash());
        }

        private void updateConstraints(Table origTable, Table updatedTable) {
            List origConstraints = CommonUtil.listOrEmpty((List)origTable.getTableConstraints());
            List updatedConstraints = CommonUtil.listOrEmpty((List)updatedTable.getTableConstraints());
            origConstraints.sort(EntityUtil.compareTableConstraint);
            origConstraints.stream().map(TableConstraint::getColumns).forEach(Collections::sort);
            updatedConstraints.sort(EntityUtil.compareTableConstraint);
            updatedConstraints.stream().map(TableConstraint::getColumns).forEach(Collections::sort);
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("tableConstraints", origConstraints, updatedConstraints, added, deleted, EntityUtil.tableConstraintMatch);
        }
    }

    static class ColumnDescriptionWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        private final Column column;

        ColumnDescriptionWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            Table table = (Table)Entity.getEntity(TableRepository.FIELD_RELATION_TABLE_TYPE, threadContext.getAboutEntity().getId(), TableRepository.COLUMN_FIELD, Include.ALL);
            threadContext.setAboutEntity((EntityInterface)table);
            this.column = TableRepository.getColumn((Table)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            this.column.setDescription(resolveTask.getNewValue());
            return this.threadContext.getAboutEntity();
        }
    }

    static class ColumnTagWorkflow
    extends EntityRepository.TagTaskWorkflow {
        private final Column column;

        ColumnTagWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            Table table = (Table)Entity.getEntity(TableRepository.FIELD_RELATION_TABLE_TYPE, threadContext.getAboutEntity().getId(), "columns,tags", Include.ALL);
            threadContext.setAboutEntity((EntityInterface)table);
            this.column = TableRepository.getColumn((Table)threadContext.getAboutEntity(), threadContext.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            this.column.setTags(tags);
            return this.threadContext.getAboutEntity();
        }
    }

    public static class TableCsv
    extends EntityCsv<Table> {
        public static final CsvDocumentation DOCUMENTATION = TableCsv.getCsvDocumentation("table");
        public static final List<CsvHeader> HEADERS = DOCUMENTATION.getHeaders();
        public static final List<CsvHeader> COLUMN_HEADERS = TableCsv.resetRequiredColumns(DOCUMENTATION.getHeaders(), CommonUtil.listOf((Object[])new String[]{"name"}));
        private final Table table;

        TableCsv(Table table, String user) {
            super(TableRepository.FIELD_RELATION_TABLE_TYPE, HEADERS, user);
            this.table = table;
        }

        @Override
        protected void createEntity(CSVPrinter printer, List<CSVRecord> csvRecords) throws IOException {
            CSVRecord csvRecord = this.getNextRecord(printer, csvRecords);
            if (this.processRecord) {
                this.table.withName(csvRecord.get(0)).withDisplayName(csvRecord.get(1)).withDescription(csvRecord.get(2)).withOwner(this.getOwner(printer, csvRecord, 3)).withTags(this.getTagLabels(printer, csvRecord, 4)).withRetentionPeriod(csvRecord.get(5)).withSourceUrl(csvRecord.get(6)).withDomain(this.getEntityReference(printer, csvRecord, 7, "domain"));
                EntityCsv.ImportResult importResult = this.updateColumn(printer, csvRecord);
                if (importResult.result().equals("failure")) {
                    this.importFailure(printer, importResult.details(), csvRecord);
                }
            }
            ArrayList<EntityCsv.ImportResult> importResults = new ArrayList<EntityCsv.ImportResult>();
            this.updateColumns(printer, csvRecords, importResults);
            if (this.processRecord) {
                this.createEntity(printer, csvRecord, this.table);
            }
            for (EntityCsv.ImportResult importResult : importResults) {
                if (importResult.result().equals("success")) {
                    this.importSuccess(printer, importResult.record(), importResult.details());
                    continue;
                }
                this.importFailure(printer, importResult.details(), importResult.record());
            }
        }

        public void updateColumns(CSVPrinter printer, List<CSVRecord> csvRecords, List<EntityCsv.ImportResult> results) throws IOException {
            while (this.recordIndex < csvRecords.size() && csvRecords.get(0) != null) {
                CSVRecord csvRecord = this.getNextRecord(printer, COLUMN_HEADERS, csvRecords);
                results.add(this.updateColumn(printer, csvRecord));
            }
        }

        public EntityCsv.ImportResult updateColumn(CSVPrinter printer, CSVRecord csvRecord) throws IOException {
            if (!this.processRecord) {
                return new EntityCsv.ImportResult("skipped", csvRecord, "");
            }
            String columnFqn = csvRecord.get(8);
            Column column = this.findColumn(this.table.getColumns(), columnFqn);
            if (column == null) {
                this.processRecord = false;
                return new EntityCsv.ImportResult("failure", csvRecord, TableCsv.columnNotFound(8, columnFqn));
            }
            column.withDisplayName(csvRecord.get(9));
            column.withDescription(csvRecord.get(10));
            column.withDataTypeDisplay(csvRecord.get(11));
            column.withTags(this.getTagLabels(printer, csvRecord, 12));
            return new EntityCsv.ImportResult("success", csvRecord, "Entity updated");
        }

        @Override
        protected void addRecord(CsvFile csvFile, Table entity) {
            ArrayList<String> recordList = new ArrayList<String>();
            CsvUtil.addField(recordList, entity.getName());
            CsvUtil.addField(recordList, entity.getDisplayName());
            CsvUtil.addField(recordList, entity.getDescription());
            CsvUtil.addOwner(recordList, entity.getOwner());
            CsvUtil.addTagLabels(recordList, entity.getTags());
            CsvUtil.addField(recordList, entity.getRetentionPeriod());
            CsvUtil.addField(recordList, entity.getSourceUrl());
            String domain = entity.getDomain() == null || Boolean.TRUE.equals(entity.getDomain().getInherited()) ? "" : entity.getDomain().getFullyQualifiedName();
            CsvUtil.addField(recordList, domain);
            this.addRecord(csvFile, recordList, (Column)this.table.getColumns().get(0), false);
            for (int i = 1; i < entity.getColumns().size(); ++i) {
                this.addRecord(csvFile, new ArrayList<String>(), (Column)this.table.getColumns().get(1), true);
            }
        }

        private void addRecord(CsvFile csvFile, List<String> recordList, Column column, boolean emptyTableDetails) {
            if (emptyTableDetails) {
                for (int i = 0; i < 8; ++i) {
                    CsvUtil.addField(recordList, (String)null);
                }
            }
            CsvUtil.addField(recordList, EntityUtil.getLocalColumnName(this.table.getFullyQualifiedName(), column.getFullyQualifiedName()));
            CsvUtil.addField(recordList, column.getDisplayName());
            CsvUtil.addField(recordList, column.getDescription());
            CsvUtil.addField(recordList, column.getDataTypeDisplay());
            CsvUtil.addTagLabels(recordList, column.getTags());
            this.addRecord(csvFile, recordList);
            CommonUtil.listOrEmpty((List)column.getChildren()).forEach(c -> this.addRecord(csvFile, (List<String>)new ArrayList<String>(), (Column)c, true));
        }

        private Column findColumn(List<Column> columns, String columnFqn) {
            for (Column c : CommonUtil.listOrEmpty(columns)) {
                String tableFqn = this.table.getFullyQualifiedName();
                Column column = EntityUtil.getLocalColumnName(tableFqn, c.getFullyQualifiedName()).equals(columnFqn) ? c : this.findColumn(c.getChildren(), columnFqn);
                if (column == null) continue;
                return column;
            }
            return null;
        }
    }
}

