/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.utils.v111;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUtilV111 {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationUtilV111.class);

    private MigrationUtilV111() {
    }

    public static void removeDuplicateTestCases(CollectionDAO collectionDAO, Handle handle, String getSql) {
        List resultList = handle.createQuery(getSql).mapToMap().list();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map idMap : resultList) {
            String id1 = (String)idMap.get("id1");
            String id2 = (String)idMap.get("id2");
            if (resultMap.containsKey(id1) || resultMap.containsKey(id2)) continue;
            resultMap.put(id1, id2);
        }
        resultMap.forEach((k, v) -> {
            UUID toId;
            UUID id = UUID.fromString(k);
            List<CollectionDAO.EntityRelationshipRecord> records = collectionDAO.relationshipDAO().findTo(id, "testSuite", Relationship.CONTAINS.ordinal(), "testCase");
            List<CollectionDAO.EntityRelationshipRecord> ingestionRecords = collectionDAO.relationshipDAO().findTo(id, "testSuite", Relationship.CONTAINS.ordinal(), "ingestionPipeline");
            for (CollectionDAO.EntityRelationshipRecord relationRecord : records) {
                toId = relationRecord.getId();
                collectionDAO.relationshipDAO().insert(UUID.fromString(v), toId, "testSuite", "testCase", Relationship.CONTAINS.ordinal());
            }
            try {
                collectionDAO.testSuiteDAO().delete(id);
                collectionDAO.relationshipDAO().deleteAllWithId(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (CollectionDAO.EntityRelationshipRecord relationshipRecord : ingestionRecords) {
                try {
                    toId = relationshipRecord.getId();
                    collectionDAO.ingestionPipelineDAO().delete(toId);
                    collectionDAO.relationshipDAO().deleteAllWithId(toId);
                }
                catch (Exception exception) {}
            }
        });
    }

    public static void runTestSuiteMigration(CollectionDAO collectionDAO, Handle handle, String getSql, String updateSql, String resultListSql) {
        List resultList = handle.createQuery(resultListSql).mapToMap().list();
        for (Map row : resultList) {
            Object json = row.get("json");
            if (json == null) continue;
            TestSuite suite = null;
            if (json instanceof String) {
                String str = (String)json;
                suite = JsonUtils.readValue(str, TestSuite.class);
            } else if (json instanceof PGobject) {
                PGobject pgObject = (PGobject)json;
                suite = JsonUtils.readValue(pgObject.getValue(), TestSuite.class);
            }
            if (!Boolean.TRUE.equals(suite.getExecutable())) continue;
            if (suite.getExecutableEntityReference() != null) {
                MigrationUtilV111.updateTestSuite(handle, suite, updateSql);
                continue;
            }
            String entityName = StringUtils.replaceOnce((String)suite.getDisplayName(), (String)".testSuite", (String)"");
            try {
                Table table = (Table)collectionDAO.tableDAO().findEntityByName(entityName, Include.ALL);
                suite.setExecutable(Boolean.valueOf(true));
                suite.setExecutableEntityReference(table.getEntityReference());
                MigrationUtilV111.updateTestSuite(handle, suite, updateSql);
                MigrationUtilV111.removeDuplicateTestCases(collectionDAO, handle, getSql);
            }
            catch (Exception ex) {
                try {
                    collectionDAO.testSuiteDAO().delete(suite.getId());
                    collectionDAO.relationshipDAO().deleteAllWithId(suite.getId());
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void updateTestSuite(Handle handle, TestSuite suite, String updateSql) {
        if (suite.getExecutableEntityReference() != null) {
            try {
                EntityReference executableEntityRef = suite.getExecutableEntityReference();
                suite.setName(String.format("%s.testSuite", executableEntityRef.getName()));
                suite.setFullyQualifiedName(String.format("%s.testSuite", executableEntityRef.getFullyQualifiedName()));
                int result = ((Update)((Update)((Update)handle.createUpdate(updateSql).bind("json", JsonUtils.pojoToJson(suite))).bind("fqnHash", FullyQualifiedName.buildHash(suite.getFullyQualifiedName()))).bind("id", suite.getId().toString())).execute();
                if (result <= 0) {
                    LOG.error("No Rows Affected for 1.1.1 test suite Migration");
                }
            }
            catch (Exception ex) {
                LOG.error("Error in Updating Test Suite with FQN : {}", (Object)suite.getFullyQualifiedName(), (Object)ex);
                throw ex;
            }
        }
    }
}

