/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.apps;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.api.configuration.apps.AppPrivateConfig;
import org.openmetadata.schema.api.configuration.apps.AppsPrivateConfiguration;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppMarketPlaceDefinition;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.app.AppType;
import org.openmetadata.schema.entity.app.CreateApp;
import org.openmetadata.schema.entity.app.ScheduleType;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.sdk.PipelineServiceClient;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.apps.ApplicationHandler;
import org.openmetadata.service.apps.scheduler.AppScheduler;
import org.openmetadata.service.clients.pipeline.PipelineServiceClientFactory;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.AppRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.secrets.masker.EntityMaskerFactory;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.OpenMetadataConnectionBuilder;
import org.openmetadata.service.util.ResultList;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/apps")
@Tag(name="Apps", description="Apps are internal/external apps used to something on top of Open-metadata.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="apps")
public class AppResource
extends EntityResource<App, AppRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(AppResource.class);
    public static final String COLLECTION_PATH = "v1/apps/";
    private OpenMetadataApplicationConfig openMetadataApplicationConfig;
    private AppsPrivateConfiguration privateConfiguration;
    private PipelineServiceClient pipelineServiceClient;
    static final String FIELDS = "owner";
    private SearchRepository searchRepository;

    @Override
    public void initialize(OpenMetadataApplicationConfig config) {
        try {
            this.openMetadataApplicationConfig = config;
            this.privateConfiguration = config.getAppsPrivateConfiguration();
            this.pipelineServiceClient = PipelineServiceClientFactory.createPipelineServiceClient(config.getPipelineServiceClientConfiguration());
            CollectionDAO dao = Entity.getCollectionDAO();
            this.searchRepository = new SearchRepository(config.getElasticSearchConfiguration());
            AppScheduler.initialize(config, dao, this.searchRepository);
            List<CreateApp> createAppsReq = EntityRepository.getEntitiesFromSeedData("app", String.format(".*json/data/%s/.*\\.json$", this.entityType), CreateApp.class);
            for (CreateApp createApp : createAppsReq) {
                AppMarketPlaceDefinition definition = (AppMarketPlaceDefinition)((AppRepository)this.repository).getMarketPlace().getByName(null, createApp.getName(), new EntityUtil.Fields(((AppRepository)this.repository).getMarketPlace().getAllowedFields()));
                App app = this.getAppForInit(createApp.getName());
                if (app == null) {
                    app = this.getApplication(definition, createApp, "admin").withFullyQualifiedName(createApp.getName());
                    ((AppRepository)this.repository).initializeEntity(app);
                }
                if (!app.getScheduleType().equals((Object)ScheduleType.Scheduled)) continue;
                this.setAppRuntimeProperties(app);
                ApplicationHandler.installApplication(app, Entity.getCollectionDAO(), this.searchRepository);
            }
            for (App installedApp : ((AppRepository)this.repository).listAll()) {
                App appWithBot = this.getAppForInit(installedApp.getName());
                if (appWithBot == null) {
                    LOG.error(String.format("Failed to init app [%s]. GET should return the installed app", installedApp.getName()));
                    continue;
                }
                this.setAppRuntimeProperties(appWithBot);
                ApplicationHandler.runAppInit(appWithBot, dao, this.searchRepository);
                LOG.info(String.format("Initialized installed app [%s]", installedApp.getName()));
            }
        }
        catch (Exception ex) {
            LOG.error("Failed in Create App Requests", (Throwable)ex);
        }
    }

    private App getAppForInit(String appName) {
        try {
            return (App)((AppRepository)this.repository).getByName(null, appName, ((AppRepository)this.repository).getFields("bot,pipelines"), Include.ALL, false);
        }
        catch (EntityNotFoundException ex) {
            return null;
        }
    }

    public AppResource(Authorizer authorizer) {
        super("app", authorizer);
    }

    private void setAppRuntimeProperties(App app) {
        app.setOpenMetadataServerConnection(new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig, app.getBot().getName()).build());
        if (this.privateConfiguration != null && !CommonUtil.nullOrEmpty((List)this.privateConfiguration.getAppsPrivateConfiguration())) {
            for (AppPrivateConfig appPrivateConfig : this.privateConfiguration.getAppsPrivateConfiguration()) {
                if (!app.getName().equals(appPrivateConfig.getName())) continue;
                app.setPrivateConfiguration((Object)appPrivateConfig.getParameters());
            }
        }
    }

    private void unsetAppRuntimeProperties(App app) {
        app.setOpenMetadataServerConnection(null);
        app.setPrivateConfiguration(null);
    }

    @GET
    @Operation(operationId="listInstalledApplications", summary="List installed application", description="Get a list of applications. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of Installed Applications", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppList.class))})})
    public ResultList<App> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number of installed applications returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tests before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tests after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/name/{name}/status")
    @Operation(operationId="listAppRunRecords", summary="List App Run Records", description="Get a list of applications Run Record. Use cursor-based pagination to limit the number entries in the list using `offset` query params.", responses={@ApiResponse(responseCode="200", description="List of Installed Applications Runs", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppRunList.class))})})
    public Response listAppRuns(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Limit records. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Offset records. (0 to 1000000, default = 0)") @DefaultValue(value="0") @QueryParam(value="offset") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int offset, @Parameter(description="Filter pipeline status after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") Long startTs, @Parameter(description="Filter pipeline status before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") Long endTs) {
        App installation = (App)((AppRepository)this.repository).getByName(uriInfo, name, ((AppRepository)this.repository).getFields("id,pipelines"));
        if (installation.getAppType().equals((Object)AppType.Internal)) {
            return Response.status((Response.Status)Response.Status.OK).entity(((AppRepository)this.repository).listAppRuns(installation.getId(), limitParam, offset)).build();
        }
        if (!installation.getPipelines().isEmpty()) {
            EntityReference pipelineRef = (EntityReference)installation.getPipelines().get(0);
            IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            IngestionPipeline ingestionPipeline = (IngestionPipeline)ingestionPipelineRepository.get(uriInfo, pipelineRef.getId(), ingestionPipelineRepository.getFields(FIELDS));
            return Response.ok(ingestionPipelineRepository.listPipelineStatus(ingestionPipeline.getFullyQualifiedName(), startTs, endTs), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        throw new IllegalArgumentException("App does not have an associated pipeline.");
    }

    @GET
    @Path(value="/name/{name}/logs")
    @Operation(summary="Retrieve all logs from last ingestion pipeline run for the application", description="Get all logs from last ingestion pipeline run by `Id`.", responses={@ApiResponse(responseCode="200", description="JSON object with the task instance name of the ingestion on each key and log in the value", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Logs for instance {id} is not found")})
    public Response getLastLogs(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Returns log chunk after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") @DefaultValue(value="") String after) {
        App installation = (App)((AppRepository)this.repository).getByName(uriInfo, name, ((AppRepository)this.repository).getFields("id,pipelines"));
        if (installation.getAppType().equals((Object)AppType.Internal)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)((AppRepository)this.repository).getLatestAppRuns(installation.getId())).build();
        }
        if (!installation.getPipelines().isEmpty()) {
            EntityReference pipelineRef = (EntityReference)installation.getPipelines().get(0);
            IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            IngestionPipeline ingestionPipeline = (IngestionPipeline)ingestionPipelineRepository.get(uriInfo, pipelineRef.getId(), ingestionPipelineRepository.getFields(FIELDS));
            return Response.ok((Object)this.pipelineServiceClient.getLastIngestionLogs(ingestionPipeline, after), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        throw new BadRequestException("Failed to Get Logs for the Installation.");
    }

    @GET
    @Path(value="/name/{name}/runs/latest")
    @Operation(operationId="latestAppRunRecord", summary="Get Latest App Run Record", description="Get a latest applications Run Record.", responses={@ApiResponse(responseCode="200", description="List of Installed Applications Runs", content={@Content(mediaType="application/json", schema=@Schema(implementation=AppRunRecord.class))})})
    public Response listLatestAppRun(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Returns log chunk after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") @DefaultValue(value="") String after) {
        App installation = (App)((AppRepository)this.repository).getByName(uriInfo, name, ((AppRepository)this.repository).getFields("id,pipelines"));
        if (installation.getAppType().equals((Object)AppType.Internal)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)((AppRepository)this.repository).getLatestAppRuns(installation.getId())).build();
        }
        if (!installation.getPipelines().isEmpty()) {
            EntityReference pipelineRef = (EntityReference)installation.getPipelines().get(0);
            IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            IngestionPipeline ingestionPipeline = (IngestionPipeline)ingestionPipelineRepository.get(uriInfo, pipelineRef.getId(), ingestionPipelineRepository.getFields(FIELDS));
            PipelineStatus latestPipelineStatus = ingestionPipelineRepository.getLatestPipelineStatus(ingestionPipeline);
            Map lastIngestionLogs = this.pipelineServiceClient.getLastIngestionLogs(ingestionPipeline, after);
            HashMap<String, Object> appRun = new HashMap<String, Object>();
            appRun.put("pipelineStatus", latestPipelineStatus);
            appRun.put("lastIngestionLogs", lastIngestionLogs);
            return Response.ok(appRun, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        throw new BadRequestException("Failed to Get Logs for the Installation.");
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllInstalledApplications", summary="List Installed Application versions", description="Get a list of all the versions of a application identified by `id`", responses={@ApiResponse(responseCode="200", description="List of installed application versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the app", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a app by Id", description="Get a app by `Id`.", responses={@ApiResponse(responseCode="200", description="The App", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))}), @ApiResponse(responseCode="404", description="App for instance {id} is not found")})
    public App get(@Context UriInfo uriInfo, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (App)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getAppByName", summary="Get a App by name", description="Get a App by `name`.", responses={@ApiResponse(responseCode="200", description="The App", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))}), @ApiResponse(responseCode="404", description="App for instance {name} is not found")})
    public App getByName(@Context UriInfo uriInfo, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (App)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificAppVersion", summary="Get a version of the App", description="Get a version of the App by given `id`", responses={@ApiResponse(responseCode="200", description="App", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))}), @ApiResponse(responseCode="404", description="App for instance {id} and version {version} is not found")})
    public App getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="App version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (App)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createApplication", summary="Create a Application", description="Create a application", responses={@ApiResponse(responseCode="200", description="The Application", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateApp create) {
        AppMarketPlaceDefinition definition = (AppMarketPlaceDefinition)((AppRepository)this.repository).getMarketPlace().getByName(uriInfo, create.getName(), new EntityUtil.Fields(((AppRepository)this.repository).getMarketPlace().getAllowedFields()));
        App app = this.getApplication(definition, create, securityContext.getUserPrincipal().getName());
        this.setAppRuntimeProperties(app);
        if (app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            ApplicationHandler.installApplication(app, Entity.getCollectionDAO(), this.searchRepository);
            ApplicationHandler.configureApplication(app, Entity.getCollectionDAO(), this.searchRepository);
        }
        this.unsetAppRuntimeProperties(app);
        return this.create(uriInfo, securityContext, app);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchApplication", summary="Updates a App", description="Update an existing App using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patchApplication(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws SchedulerException {
        App app = (App)((AppRepository)this.repository).get(null, id, ((AppRepository)this.repository).getFields("bot,pipelines"));
        AppScheduler.getInstance().deleteScheduledApplication(app);
        Response response = this.patchInternal(uriInfo, securityContext, id, patch);
        App updatedApp = (App)response.getEntity();
        this.setAppRuntimeProperties(updatedApp);
        if (app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            ApplicationHandler.installApplication(updatedApp, Entity.getCollectionDAO(), this.searchRepository);
        }
        this.unsetAppRuntimeProperties(updatedApp);
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateApp", summary="Create Or Update App", description="Create or Update App, it it does not exist or update an existing KPI.", responses={@ApiResponse(responseCode="200", description="The updated Application Objective ", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateApp create) throws SchedulerException {
        AppMarketPlaceDefinition definition = (AppMarketPlaceDefinition)((AppRepository)this.repository).getMarketPlace().getByName(uriInfo, create.getName(), new EntityUtil.Fields(((AppRepository)this.repository).getMarketPlace().getAllowedFields()));
        App app = this.getApplication(definition, create, securityContext.getUserPrincipal().getName());
        AppScheduler.getInstance().deleteScheduledApplication(app);
        this.setAppRuntimeProperties(app);
        if (app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            ApplicationHandler.installApplication(app, Entity.getCollectionDAO(), this.searchRepository);
        }
        this.unsetAppRuntimeProperties(app);
        return this.createOrUpdate(uriInfo, securityContext, app);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="uninstallAppByName", summary="Delete a App by name", description="Delete a App by `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="App for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        App app = (App)((AppRepository)this.repository).getByName(null, name, ((AppRepository)this.repository).getFields("bot,pipelines"));
        this.deleteApp(securityContext, app, hardDelete);
        return this.deleteByName(uriInfo, securityContext, name, true, hardDelete);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="uninstallAppByName", summary="Delete a App by Id", description="Delete a App by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="App for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the App", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        App app = (App)((AppRepository)this.repository).get(null, id, ((AppRepository)this.repository).getFields("bot,pipelines"));
        this.deleteApp(securityContext, app, hardDelete);
        return this.delete(uriInfo, securityContext, id, true, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted KPI", description="Restore a soft deleted App.", responses={@ApiResponse(responseCode="200", description="Successfully restored the App. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=App.class))})})
    public Response restoreApp(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        Response response = this.restoreEntity(uriInfo, securityContext, restore.getId());
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            App app = (App)response.getEntity();
            this.setAppRuntimeProperties(app);
            if (app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
                ApplicationHandler.installApplication(app, Entity.getCollectionDAO(), this.searchRepository);
            }
            this.unsetAppRuntimeProperties(app);
        }
        return response;
    }

    @POST
    @Path(value="/schedule/{name}")
    @Operation(operationId="scheduleApplication", summary="Schedule an Application", description="Schedule a application to be run on demand.", responses={@ApiResponse(responseCode="200", description="The Application", content={@Content(mediaType="application/json", schema=@Schema(implementation=Response.class))}), @ApiResponse(responseCode="404", description="Application for instance {id} is not found")})
    public Response scheduleApplication(@Context UriInfo uriInfo, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name, @Context SecurityContext securityContext) {
        App app = (App)((AppRepository)this.repository).getByName(uriInfo, name, new EntityUtil.Fields(((AppRepository)this.repository).getAllowedFields()));
        this.setAppRuntimeProperties(app);
        if (app.getScheduleType().equals((Object)ScheduleType.Scheduled)) {
            ApplicationHandler.installApplication(app, ((AppRepository)this.repository).getDaoCollection(), this.searchRepository);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"App is Scheduled.").build();
        }
        throw new IllegalArgumentException("App is not of schedule type Scheduled.");
    }

    @POST
    @Path(value="/configure/{name}")
    @Operation(operationId="configureApplication", summary="Configure an Application", description="Schedule a application to be run on demand.", responses={@ApiResponse(responseCode="200", description="The Application", content={@Content(mediaType="application/json", schema=@Schema(implementation=Response.class))}), @ApiResponse(responseCode="404", description="Application for instance {id} is not found")})
    public Response configureApplication(@Context UriInfo uriInfo, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name, @Context SecurityContext securityContext) {
        App app = (App)((AppRepository)this.repository).getByName(uriInfo, name, new EntityUtil.Fields(((AppRepository)this.repository).getAllowedFields()));
        this.setAppRuntimeProperties(app);
        try {
            ApplicationHandler.configureApplication(app, ((AppRepository)this.repository).getDaoCollection(), this.searchRepository);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"App has been configured.").build();
        }
        catch (RuntimeException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Error configuring app [%s]", e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/trigger/{name}")
    @Operation(operationId="triggerApplicationRun", summary="Trigger an Application run", description="Trigger a Application run by id.", responses={@ApiResponse(responseCode="200", description="Application trigger status code", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Application for instance {id} is not found")})
    public Response triggerApplicationRun(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        EntityUtil.Fields fields = this.getFields(String.format("%s,bot,pipelines", FIELDS));
        App app = (App)((AppRepository)this.repository).getByName(uriInfo, name, fields);
        this.setAppRuntimeProperties(app);
        if (app.getAppType().equals((Object)AppType.Internal)) {
            ApplicationHandler.triggerApplicationOnDemand(app, Entity.getCollectionDAO(), this.searchRepository);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Application Triggered").build();
        }
        if (!app.getPipelines().isEmpty()) {
            EntityReference pipelineRef = (EntityReference)app.getPipelines().get(0);
            IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            IngestionPipeline ingestionPipeline = (IngestionPipeline)ingestionPipelineRepository.get(uriInfo, pipelineRef.getId(), ingestionPipelineRepository.getFields(FIELDS));
            ingestionPipeline.setOpenMetadataServerConnection(app.getOpenMetadataServerConnection());
            this.decryptOrNullify(securityContext, ingestionPipeline, app.getBot().getName(), true);
            ServiceEntityInterface service = (ServiceEntityInterface)Entity.getEntity(ingestionPipeline.getService(), "", Include.NON_DELETED);
            PipelineServiceClientResponse response = this.pipelineServiceClient.runPipeline(ingestionPipeline, service);
            return Response.status((int)response.getCode()).entity((Object)response).build();
        }
        throw new BadRequestException("Failed to trigger application.");
    }

    @POST
    @Path(value="/deploy/{name}")
    @Operation(operationId="deployApplicationToQuartzOrIngestion", summary="Deploy App to Quartz or Ingestion", description="Deploy App to Quartz or Ingestion.", responses={@ApiResponse(responseCode="200", description="Application trigger status code", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Application for instance {id} is not found")})
    public Response deployApplicationFlow(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the App", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        EntityUtil.Fields fields = this.getFields(String.format("%s,bot,pipelines", FIELDS));
        App app = (App)((AppRepository)this.repository).getByName(uriInfo, name, fields);
        this.setAppRuntimeProperties(app);
        if (app.getAppType().equals((Object)AppType.Internal)) {
            ApplicationHandler.installApplication(app, Entity.getCollectionDAO(), this.searchRepository);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Application Deployed").build();
        }
        if (!app.getPipelines().isEmpty()) {
            EntityReference pipelineRef = (EntityReference)app.getPipelines().get(0);
            IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            IngestionPipeline ingestionPipeline = (IngestionPipeline)ingestionPipelineRepository.get(uriInfo, pipelineRef.getId(), ingestionPipelineRepository.getFields(FIELDS));
            ingestionPipeline.setOpenMetadataServerConnection(app.getOpenMetadataServerConnection());
            this.decryptOrNullify(securityContext, ingestionPipeline, app.getBot().getName(), true);
            ServiceEntityInterface service = (ServiceEntityInterface)Entity.getEntity(ingestionPipeline.getService(), "", Include.NON_DELETED);
            PipelineServiceClientResponse status = this.pipelineServiceClient.deployPipeline(ingestionPipeline, service);
            if (status.getCode() == 200) {
                ingestionPipelineRepository.createOrUpdate(uriInfo, ingestionPipeline);
            } else {
                ingestionPipeline.setDeployed(Boolean.valueOf(false));
            }
            return Response.status((int)status.getCode()).entity((Object)status).build();
        }
        throw new BadRequestException("Failed to trigger application.");
    }

    private void decryptOrNullify(SecurityContext securityContext, IngestionPipeline ingestionPipeline, String botName, boolean forceNotMask) {
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        try {
            this.authorizer.authorize(securityContext, new OperationContext(this.entityType, MetadataOperation.VIEW_ALL), this.getResourceContextById(ingestionPipeline.getId()));
        }
        catch (AuthorizationException e) {
            ingestionPipeline.getSourceConfig().setConfig(null);
        }
        secretsManager.decryptIngestionPipeline(ingestionPipeline);
        OpenMetadataConnection openMetadataServerConnection = new OpenMetadataConnectionBuilder(this.openMetadataApplicationConfig, botName).build();
        ingestionPipeline.setOpenMetadataServerConnection(secretsManager.encryptOpenMetadataConnection(openMetadataServerConnection, false));
        if (this.authorizer.shouldMaskPasswords(securityContext) && !forceNotMask) {
            EntityMaskerFactory.getEntityMasker().maskIngestionPipeline(ingestionPipeline);
        }
    }

    private App getApplication(AppMarketPlaceDefinition marketPlaceDefinition, CreateApp createAppRequest, String updatedBy) {
        EntityReference owner = ((AppRepository)this.repository).validateOwner(createAppRequest.getOwner());
        App app = new App().withId(UUID.randomUUID()).withName(marketPlaceDefinition.getName()).withDisplayName(createAppRequest.getDisplayName()).withDescription(createAppRequest.getDescription()).withOwner(owner).withUpdatedBy(updatedBy).withUpdatedAt(Long.valueOf(System.currentTimeMillis())).withDeveloper(marketPlaceDefinition.getDeveloper()).withDeveloperUrl(marketPlaceDefinition.getDeveloperUrl()).withPrivacyPolicyUrl(marketPlaceDefinition.getPrivacyPolicyUrl()).withSupportEmail(marketPlaceDefinition.getSupportEmail()).withClassName(marketPlaceDefinition.getClassName()).withAppType(marketPlaceDefinition.getAppType()).withScheduleType(marketPlaceDefinition.getScheduleType()).withAppConfiguration(createAppRequest.getAppConfiguration()).withRuntime(marketPlaceDefinition.getRuntime()).withPermission(marketPlaceDefinition.getPermission()).withAppSchedule(createAppRequest.getAppSchedule()).withAppLogoUrl(marketPlaceDefinition.getAppLogoUrl()).withAppScreenshots(marketPlaceDefinition.getAppScreenshots()).withFeatures(marketPlaceDefinition.getFeatures()).withSourcePythonClass(marketPlaceDefinition.getSourcePythonClass()).withAllowConfiguration(marketPlaceDefinition.getAllowConfiguration());
        this.validateAndAddBot(app, createAppRequest.getBot());
        return app;
    }

    private void validateAndAddBot(App app, String botName) {
        if (!CommonUtil.nullOrEmpty((String)botName)) {
            app.setBot(Entity.getEntityReferenceByName("bot", botName, Include.NON_DELETED));
        } else {
            app.setBot(((AppRepository)this.repository).createNewAppBot(app));
        }
    }

    private void deleteApp(SecurityContext securityContext, App installedApp, boolean hardDelete) {
        if (installedApp.getAppType().equals((Object)AppType.Internal)) {
            try {
                AppScheduler.getInstance().deleteScheduledApplication(installedApp);
            }
            catch (SchedulerException ex) {
                LOG.error("Failed in delete Application from Scheduler.", (Throwable)ex);
                throw new InternalServerErrorException("Failed in Delete App from Scheduler.");
            }
        }
        if (!CommonUtil.nullOrEmpty((List)installedApp.getPipelines())) {
            EntityReference pipelineRef = (EntityReference)installedApp.getPipelines().get(0);
            IngestionPipelineRepository ingestionPipelineRepository = (IngestionPipelineRepository)Entity.getEntityRepository("ingestionPipeline");
            IngestionPipeline ingestionPipeline = (IngestionPipeline)ingestionPipelineRepository.get(null, pipelineRef.getId(), ingestionPipelineRepository.getFields(FIELDS));
            try {
                if (hardDelete) {
                    if (!CommonUtil.nullOrEmpty((List)installedApp.getPipelines())) {
                        this.pipelineServiceClient.deletePipeline(ingestionPipeline);
                    }
                } else if (Boolean.TRUE.equals(ingestionPipeline.getDeployed())) {
                    this.decryptOrNullify(securityContext, ingestionPipeline, installedApp.getBot().getName(), true);
                    this.pipelineServiceClient.killIngestion(ingestionPipeline);
                }
            }
            catch (Exception ex) {
                LOG.error("Failed in Pipeline Service Client : ", (Throwable)ex);
            }
        }
        ApplicationHandler.removeUninstalledApp(installedApp.getClassName());
    }

    public static class AppRunList
    extends ResultList<AppRunRecord> {
    }

    public static class AppList
    extends ResultList<App> {
    }
}

