/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class IngestionPipelineIndex
implements SearchIndex {
    final IngestionPipeline ingestionPipeline;
    final List<String> excludeFields = List.of("changeDescription", "sourceConfig", "openMetadataServerConnection", "airflowConfig");

    public IngestionPipelineIndex(IngestionPipeline ingestionPipeline) {
        this.ingestionPipeline = ingestionPipeline;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.ingestionPipeline);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.ingestionPipeline.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.ingestionPipeline.getDisplayName()).weight(10).build());
        serviceSuggest.add(SearchSuggest.builder().input(this.ingestionPipeline.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("ingestionPipeline", (EntityInterface)this.ingestionPipeline));
        doc.put("name", this.ingestionPipeline.getName() != null ? this.ingestionPipeline.getName() : this.ingestionPipeline.getDisplayName());
        doc.put("displayName", this.ingestionPipeline.getDisplayName() != null ? this.ingestionPipeline.getDisplayName() : this.ingestionPipeline.getName());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.ingestionPipeline.getFollowers()));
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("suggest", suggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "ingestionPipeline");
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.ingestionPipeline.getVotes()) ? 0 : this.ingestionPipeline.getVotes().getUpVotes() - this.ingestionPipeline.getVotes().getDownVotes());
        doc.put("fqnParts", this.getFQNParts(this.ingestionPipeline.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("owner", this.getEntityWithDisplayName(this.ingestionPipeline.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.ingestionPipeline.getService()));
        doc.put("domain", this.getEntityWithDisplayName(this.ingestionPipeline.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

