/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.entity.services.SearchService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public record SearchServiceIndex(SearchService searchService) implements SearchIndex
{
    private static final List<String> excludeFields = List.of("changeDescription");

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.searchService);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.searchService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.searchService.getFullyQualifiedName()).weight(5).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "searchService");
        doc.put("fqnParts", this.getFQNParts(this.searchService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("owner", this.getEntityWithDisplayName(this.searchService.getOwner()));
        return doc;
    }
}

