/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.Map;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.automations.TestServiceConnectionRequest;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.metadataIngestion.DbtPipeline;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtGCSConfig;
import org.openmetadata.schema.security.credentials.GCPCredentials;
import org.openmetadata.schema.services.connections.dashboard.LookerConnection;
import org.openmetadata.schema.services.connections.dashboard.SupersetConnection;
import org.openmetadata.schema.services.connections.dashboard.TableauConnection;
import org.openmetadata.schema.services.connections.database.BigQueryConnection;
import org.openmetadata.schema.services.connections.database.BigTableConnection;
import org.openmetadata.schema.services.connections.database.DatalakeConnection;
import org.openmetadata.schema.services.connections.database.HiveConnection;
import org.openmetadata.schema.services.connections.database.IcebergConnection;
import org.openmetadata.schema.services.connections.database.MysqlConnection;
import org.openmetadata.schema.services.connections.database.PostgresConnection;
import org.openmetadata.schema.services.connections.database.TrinoConnection;
import org.openmetadata.schema.services.connections.database.datalake.GCSConfig;
import org.openmetadata.schema.services.connections.database.iceberg.IcebergFileSystem;
import org.openmetadata.schema.services.connections.pipeline.AirflowConnection;
import org.openmetadata.schema.services.connections.search.ElasticSearchConnection;
import org.openmetadata.schema.services.connections.storage.GCSConnection;
import org.openmetadata.service.secrets.converter.AirflowConnectionClassConverter;
import org.openmetadata.service.secrets.converter.BigQueryConnectionClassConverter;
import org.openmetadata.service.secrets.converter.BigTableConnectionClassConverter;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.secrets.converter.DatalakeConnectionClassConverter;
import org.openmetadata.service.secrets.converter.DbtGCSConfigClassConverter;
import org.openmetadata.service.secrets.converter.DbtPipelineClassConverter;
import org.openmetadata.service.secrets.converter.DefaultConnectionClassConverter;
import org.openmetadata.service.secrets.converter.ElasticSearchConnectionClassConverter;
import org.openmetadata.service.secrets.converter.GCPConfigClassConverter;
import org.openmetadata.service.secrets.converter.GcpConnectionClassConverter;
import org.openmetadata.service.secrets.converter.GcpCredentialsClassConverter;
import org.openmetadata.service.secrets.converter.HiveConnectionClassConverter;
import org.openmetadata.service.secrets.converter.IcebergConnectionClassConverter;
import org.openmetadata.service.secrets.converter.IcebergFileSystemClassConverter;
import org.openmetadata.service.secrets.converter.LookerConnectionClassConverter;
import org.openmetadata.service.secrets.converter.MysqlConnectionClassConverter;
import org.openmetadata.service.secrets.converter.PostgresConnectionClassConverter;
import org.openmetadata.service.secrets.converter.SSOAuthMechanismClassConverter;
import org.openmetadata.service.secrets.converter.SupersetConnectionClassConverter;
import org.openmetadata.service.secrets.converter.TableauConnectionClassConverter;
import org.openmetadata.service.secrets.converter.TestServiceConnectionRequestClassConverter;
import org.openmetadata.service.secrets.converter.TrinoConnectionClassConverter;
import org.openmetadata.service.secrets.converter.WorkflowClassConverter;

public final class ClassConverterFactory {
    private static final Map<Class<?>, ClassConverter> converterMap = Map.ofEntries(Map.entry(AirflowConnection.class, new AirflowConnectionClassConverter()), Map.entry(BigQueryConnection.class, new BigQueryConnectionClassConverter()), Map.entry(BigTableConnection.class, new BigTableConnectionClassConverter()), Map.entry(DatalakeConnection.class, new DatalakeConnectionClassConverter()), Map.entry(MysqlConnection.class, new MysqlConnectionClassConverter()), Map.entry(HiveConnection.class, new HiveConnectionClassConverter()), Map.entry(TrinoConnection.class, new TrinoConnectionClassConverter()), Map.entry(PostgresConnection.class, new PostgresConnectionClassConverter()), Map.entry(DbtGCSConfig.class, new DbtGCSConfigClassConverter()), Map.entry(DbtPipeline.class, new DbtPipelineClassConverter()), Map.entry(GCSConfig.class, new GCPConfigClassConverter()), Map.entry(GCPCredentials.class, new GcpCredentialsClassConverter()), Map.entry(GCSConnection.class, new GcpConnectionClassConverter()), Map.entry(ElasticSearchConnection.class, new ElasticSearchConnectionClassConverter()), Map.entry(LookerConnection.class, new LookerConnectionClassConverter()), Map.entry(SSOAuthMechanism.class, new SSOAuthMechanismClassConverter()), Map.entry(SupersetConnection.class, new SupersetConnectionClassConverter()), Map.entry(TableauConnection.class, new TableauConnectionClassConverter()), Map.entry(TestServiceConnectionRequest.class, new TestServiceConnectionRequestClassConverter()), Map.entry(IcebergConnection.class, new IcebergConnectionClassConverter()), Map.entry(IcebergFileSystem.class, new IcebergFileSystemClassConverter()), Map.entry(Workflow.class, new WorkflowClassConverter()));

    private ClassConverterFactory() {
    }

    public static ClassConverter getConverter(Class<?> clazz) {
        return converterMap.getOrDefault(clazz, new DefaultConnectionClassConverter(clazz));
    }

    public static Map<Class<?>, ClassConverter> getConverterMap() {
        return converterMap;
    }
}

