/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.util.EntityUtil;

public class CreateResourceContext<T extends EntityInterface>
implements ResourceContextInterface {
    @NonNull
    private final String resource;
    private final EntityRepository<T> entityRepository;
    private final T entity;
    private EntityInterface parentEntity;

    public CreateResourceContext(@NonNull String resource, @NotNull T entity) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.resource = resource;
        this.entityRepository = Entity.getEntityRepository(resource);
        this.entity = entity;
        this.setParent(entity);
    }

    @Override
    public EntityReference getOwner() {
        return this.parentEntity == null ? null : this.parentEntity.getOwner();
    }

    @Override
    public List<TagLabel> getTags() {
        return this.parentEntity == null ? Collections.emptyList() : Entity.getEntityTags(this.getResource(), this.parentEntity);
    }

    @Override
    public EntityInterface getEntity() {
        return this.entity;
    }

    private void setParent(T entity) {
        String fields = "";
        if (this.entityRepository.isSupportsOwner()) {
            fields = EntityUtil.addField(fields, "owner");
        }
        if (this.entityRepository.isSupportsTags()) {
            fields = EntityUtil.addField(fields, "tags");
        }
        if (this.entityRepository.isSupportsDomain()) {
            fields = EntityUtil.addField(fields, "domain");
        }
        if (this.entityRepository.isSupportsReviewers()) {
            fields = EntityUtil.addField(fields, "reviewers");
        }
        try {
            this.parentEntity = this.entityRepository.getParentEntity(entity, fields);
        }
        catch (EntityNotFoundException e) {
            this.parentEntity = null;
        }
    }

    @Override
    @NonNull
    public String getResource() {
        return this.resource;
    }
}

