/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.openmetadata.schema.FqnBaseListener;
import org.openmetadata.schema.FqnLexer;
import org.openmetadata.schema.FqnParser;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.util.EntityUtil;

public class FullyQualifiedName {
    private static final Pattern namePattern = Pattern.compile("^(\")([^\"]+)(\")$|^(.*)$");

    private FullyQualifiedName() {
    }

    public static String add(String fqn, String part) {
        return fqn + "." + FullyQualifiedName.quoteName(part);
    }

    public static String build(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : strings) {
            list.add(FullyQualifiedName.quoteName(string));
        }
        return String.join((CharSequence)".", list);
    }

    public static String buildHash(String ... strings) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : strings) {
            list.add(EntityUtil.hash(FullyQualifiedName.quoteName(string)));
        }
        return String.join((CharSequence)".", list);
    }

    public static String buildHash(String fullyQualifiedName) {
        if (fullyQualifiedName != null && !fullyQualifiedName.isEmpty()) {
            String[] split = FullyQualifiedName.split(fullyQualifiedName);
            return FullyQualifiedName.buildHash(split);
        }
        return fullyQualifiedName;
    }

    public static String[] split(String string) {
        SplitListener listener = new SplitListener();
        FullyQualifiedName.walk(string, listener);
        return listener.split();
    }

    private static <L extends FqnBaseListener> void walk(String string, L listener) {
        FqnLexer fqnLexer = new FqnLexer((CharStream)CharStreams.fromString((String)string));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)fqnLexer);
        FqnParser fqnParser = new FqnParser((TokenStream)tokens);
        fqnParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        FqnParser.FqnContext fqn = fqnParser.fqn();
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk(listener, (ParseTree)fqn);
    }

    public static String getParentFQN(String fqn) {
        String[] split = FullyQualifiedName.split(fqn);
        return FullyQualifiedName.getParentFQN(split);
    }

    public static String getParentFQN(String ... fqnParts) {
        if (fqnParts.length <= 1) {
            return null;
        }
        if (fqnParts.length == 2) {
            return fqnParts[0];
        }
        String parent = FullyQualifiedName.build(fqnParts[0]);
        for (int i = 1; i < fqnParts.length - 1; ++i) {
            parent = FullyQualifiedName.add(parent, fqnParts[i]);
        }
        return parent;
    }

    public static String getRoot(String fqn) {
        String[] split = FullyQualifiedName.split(fqn);
        if (split.length <= 1) {
            return null;
        }
        return split[0];
    }

    public static boolean isParent(String childFqn, String parentFqn) {
        return childFqn.startsWith(parentFqn) && childFqn.length() > parentFqn.length();
    }

    public static String quoteName(String name) {
        Matcher matcher = namePattern.matcher(name);
        if (!matcher.find() || matcher.end() != name.length()) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidName(name));
        }
        if (matcher.group(1) != null) {
            String unquotedName = matcher.group(2);
            return unquotedName.contains(".") ? name : unquotedName;
        }
        String unquotedName = matcher.group(4);
        if (!unquotedName.contains("\"")) {
            return unquotedName.contains(".") ? "\"" + name + "\"" : unquotedName;
        }
        throw new IllegalArgumentException(CatalogExceptionMessage.invalidName(name));
    }

    public static String unquoteName(String name) {
        Matcher matcher = namePattern.matcher(name);
        if (!matcher.find() || matcher.end() != name.length()) {
            throw new IllegalArgumentException(CatalogExceptionMessage.invalidName(name));
        }
        if (matcher.group(1) != null) {
            return matcher.group(2);
        }
        return name;
    }

    public static String getTableFQN(String columnFQN) {
        String[] split = FullyQualifiedName.split(columnFQN);
        if (split.length != 5) {
            throw new IllegalArgumentException("Invalid fully qualified column name " + columnFQN);
        }
        return FullyQualifiedName.build(split[0], split[1], split[2], split[3]);
    }

    public static String getColumnName(String columnFQN) {
        return FullyQualifiedName.split(columnFQN)[4];
    }

    private static class SplitListener
    extends FqnBaseListener {
        final List<String> list = new ArrayList<String>();

        private SplitListener() {
        }

        public String[] split() {
            return this.list.toArray(new String[0]);
        }

        public void enterQuotedName(FqnParser.QuotedNameContext ctx) {
            this.list.add(ctx.getText());
        }

        public void enterUnquotedName(FqnParser.UnquotedNameContext ctx) {
            this.list.add(ctx.getText());
        }
    }
}

