/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import io.github.maksymdolgykh.dropwizard.micrometer.MicrometerBundle;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.openmetadata.service.OpenMetadataApplicationConfig;

public class MicrometerBundleSingleton {
    private static final MicrometerBundle instance = new MicrometerBundle();
    public static final PrometheusMeterRegistry prometheusMeterRegistry = MicrometerBundle.prometheusRegistry;
    private static Timer webAnalyticEvents;

    private MicrometerBundleSingleton() {
    }

    public static MicrometerBundle getInstance() {
        return instance;
    }

    public static void setWebAnalyticsEvents(OpenMetadataApplicationConfig config) {
        webAnalyticEvents = Timer.builder((String)"latency_requests").description("Request latency in seconds.").publishPercentiles(config.getEventMonitorConfiguration().getLatency()).publishPercentileHistogram().register((MeterRegistry)prometheusMeterRegistry);
    }

    public static Timer getWebAnalyticEvents() {
        return webAnalyticEvents;
    }
}

