/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityTimeSeriesInterface;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityTimeSeriesDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Repository
public abstract class EntityTimeSeriesRepository<T extends EntityTimeSeriesInterface> {
    protected final String collectionPath;
    protected final EntityTimeSeriesDAO timeSeriesDao;
    protected final SearchRepository searchRepository;
    protected final String entityType;
    protected final Class<T> entityClass;
    protected final CollectionDAO daoCollection;

    protected EntityTimeSeriesRepository(String collectionPath, EntityTimeSeriesDAO timeSeriesDao, Class<T> entityClass, String entityType) {
        this.collectionPath = collectionPath;
        this.timeSeriesDao = timeSeriesDao;
        this.entityClass = entityClass;
        this.entityType = entityType;
        this.searchRepository = Entity.getSearchRepository();
        this.daoCollection = Entity.getCollectionDAO();
        Entity.registerEntity(entityClass, entityType, this);
    }

    @Transaction
    public T createNewRecord(T recordEntity, String extension, String recordFQN) {
        recordEntity.setId(UUID.randomUUID());
        this.timeSeriesDao.insert(recordFQN, extension, this.entityType, JsonUtils.pojoToJson(recordEntity));
        this.postCreate(recordEntity);
        return recordEntity;
    }

    @Transaction
    public T createNewRecord(T recordEntity, String recordFQN) {
        recordEntity.setId(UUID.randomUUID());
        this.timeSeriesDao.insert(recordFQN, this.entityType, JsonUtils.pojoToJson(recordEntity));
        this.postCreate(recordEntity);
        return recordEntity;
    }

    protected void postCreate(T entity) {
        this.searchRepository.createTimeSeriesEntity((EntityTimeSeriesInterface)JsonUtils.deepCopy(entity, this.entityClass));
    }

    public final ResultList<T> getResultList(List<T> entities, String beforeCursor, String afterCursor, int total) {
        return new ResultList<T>(entities, beforeCursor, afterCursor, total);
    }

    protected ResultList<T> listWithOffset(String offset, ListFilter filter, int limitParam, Long startTs, Long endTs, boolean latest) {
        String afterOffset;
        int total = this.timeSeriesDao.listCount(filter, startTs, endTs, latest);
        ArrayList<EntityTimeSeriesInterface> entityList = new ArrayList<EntityTimeSeriesInterface>();
        int offsetInt = offset != null ? Integer.parseInt(RestUtil.decodeCursor(offset)) : 0;
        int afterOffsetInt = offsetInt + limitParam;
        int beforeOffsetInt = offsetInt - limitParam;
        if (beforeOffsetInt < 0) {
            beforeOffsetInt = 0;
        }
        String beforeOffset = offsetInt == 0 ? null : String.valueOf(beforeOffsetInt);
        String string = afterOffset = afterOffsetInt >= total ? null : String.valueOf(afterOffsetInt);
        if (limitParam > 0) {
            List<String> jsons = this.timeSeriesDao.listWithOffset(filter, limitParam, offsetInt, startTs, endTs, latest);
            for (String json : jsons) {
                EntityTimeSeriesInterface entity = (EntityTimeSeriesInterface)JsonUtils.readValue(json, this.entityClass);
                entityList.add(entity);
            }
            return this.getResultList(entityList, beforeOffset, afterOffset, total);
        }
        return this.getResultList(entityList, null, null, total);
    }

    public ResultList<T> list(String offset, Long startTs, Long endTs, int limitParam, ListFilter filter, boolean latest) {
        return this.listWithOffset(offset, filter, limitParam, startTs, endTs, latest);
    }

    public T getLatestRecord(String recordFQN) {
        String jsonRecord = this.timeSeriesDao.getLatestRecord(recordFQN);
        if (jsonRecord == null) {
            return null;
        }
        return (T)((EntityTimeSeriesInterface)JsonUtils.readValue(jsonRecord, this.entityClass));
    }

    public T getById(UUID id) {
        String jsonRecord = this.timeSeriesDao.getById(id);
        if (jsonRecord == null) {
            return null;
        }
        return (T)((EntityTimeSeriesInterface)JsonUtils.readValue(jsonRecord, this.entityClass));
    }

    public String getCollectionPath() {
        return this.collectionPath;
    }

    public EntityTimeSeriesDAO getTimeSeriesDao() {
        return this.timeSeriesDao;
    }

    public SearchRepository getSearchRepository() {
        return this.searchRepository;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public CollectionDAO getDaoCollection() {
        return this.daoCollection;
    }
}

