/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.lineage.AddLineage;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.type.ColumnLineage;
import org.openmetadata.schema.type.Edge;
import org.openmetadata.schema.type.EntityLineage;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.LineageDetails;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.Repository;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.util.JsonUtils;

@Repository
public class LineageRepository {
    private final CollectionDAO dao = Entity.getCollectionDAO();
    private static final SearchClient searchClient = Entity.getSearchRepository().getSearchClient();

    public LineageRepository() {
        Entity.setLineageRepository(this);
    }

    public EntityLineage get(String entityType, String id, int upstreamDepth, int downstreamDepth) {
        EntityReference ref = Entity.getEntityReferenceById(entityType, UUID.fromString(id), Include.NON_DELETED);
        return this.getLineage(ref, upstreamDepth, downstreamDepth);
    }

    public EntityLineage getByName(String entityType, String fqn, int upstreamDepth, int downstreamDepth) {
        EntityReference ref = Entity.getEntityReferenceByName(entityType, fqn, Include.NON_DELETED);
        return this.getLineage(ref, upstreamDepth, downstreamDepth);
    }

    @Transaction
    public void addLineage(AddLineage addLineage) {
        EntityReference from = addLineage.getEdge().getFromEntity();
        from = Entity.getEntityReferenceById(from.getType(), from.getId(), Include.NON_DELETED);
        EntityReference to = addLineage.getEdge().getToEntity();
        to = Entity.getEntityReferenceById(to.getType(), to.getId(), Include.NON_DELETED);
        if (addLineage.getEdge().getLineageDetails() != null && addLineage.getEdge().getLineageDetails().getPipeline() != null) {
            EntityReference pipeline = addLineage.getEdge().getLineageDetails().getPipeline();
            pipeline = Entity.getEntityReferenceById(pipeline.getType(), pipeline.getId(), Include.NON_DELETED);
            addLineage.getEdge().getLineageDetails().withPipeline(pipeline);
        }
        String detailsJson = this.validateLineageDetails(from, to, addLineage.getEdge().getLineageDetails());
        this.dao.relationshipDAO().insert(from.getId(), to.getId(), from.getType(), to.getType(), Relationship.UPSTREAM.ordinal(), detailsJson);
        this.addLineageToSearch(from, to, addLineage.getEdge().getLineageDetails());
    }

    private void addLineageToSearch(EntityReference fromEntity, EntityReference toEntity, LineageDetails lineageDetails) {
        IndexMapping sourceIndexMapping = Entity.getSearchRepository().getIndexMapping(fromEntity.getType());
        String sourceIndexName = sourceIndexMapping.getIndexName(Entity.getSearchRepository().getClusterAlias());
        IndexMapping destinationIndexMapping = Entity.getSearchRepository().getIndexMapping(toEntity.getType());
        String destinationIndexName = destinationIndexMapping.getIndexName(Entity.getSearchRepository().getClusterAlias());
        HashMap<String, Object> relationshipDetails = new HashMap<String, Object>();
        ImmutablePair from = new ImmutablePair((Object)"_id", (Object)fromEntity.getId().toString());
        ImmutablePair to = new ImmutablePair((Object)"_id", (Object)toEntity.getId().toString());
        this.processLineageData(fromEntity, toEntity, lineageDetails, relationshipDetails);
        searchClient.updateLineage(sourceIndexName, (Pair<String, String>)from, relationshipDetails);
        searchClient.updateLineage(destinationIndexName, (Pair<String, String>)to, relationshipDetails);
    }

    private void processLineageData(EntityReference fromEntity, EntityReference toEntity, LineageDetails lineageDetails, Map<String, Object> relationshipDetails) {
        HashMap<String, String> fromDetails = new HashMap<String, String>();
        HashMap<String, String> toDetails = new HashMap<String, String>();
        fromDetails.put("id", fromEntity.getId().toString());
        fromDetails.put("type", fromEntity.getType());
        fromDetails.put("fqn", fromEntity.getFullyQualifiedName());
        toDetails.put("id", toEntity.getId().toString());
        toDetails.put("type", toEntity.getType());
        toDetails.put("fqn", toEntity.getFullyQualifiedName());
        relationshipDetails.put("doc_id", fromEntity.getId().toString() + "-" + toEntity.getId().toString());
        relationshipDetails.put("fromEntity", fromDetails);
        relationshipDetails.put("toEntity", toDetails);
        if (lineageDetails != null) {
            relationshipDetails.put("pipeline", JsonUtils.getMap(CommonUtil.nullOrEmpty((Object)lineageDetails.getPipeline()) ? null : lineageDetails.getPipeline()));
            relationshipDetails.put("description", CommonUtil.nullOrEmpty((String)lineageDetails.getDescription()) ? null : lineageDetails.getDescription());
            if (!CommonUtil.nullOrEmpty((List)lineageDetails.getColumnsLineage())) {
                ArrayList<Map<String, Object>> colummnLineageList = new ArrayList<Map<String, Object>>();
                for (ColumnLineage columnLineage : lineageDetails.getColumnsLineage()) {
                    colummnLineageList.add(JsonUtils.getMap(columnLineage));
                }
                relationshipDetails.put("columns", colummnLineageList);
            }
            relationshipDetails.put("sqlQuery", CommonUtil.nullOrEmpty((String)lineageDetails.getSqlQuery()) ? null : lineageDetails.getSqlQuery());
            relationshipDetails.put("source", CommonUtil.nullOrEmpty((Object)lineageDetails.getSource()) ? null : lineageDetails.getSource());
        }
    }

    private String validateLineageDetails(EntityReference from, EntityReference to, LineageDetails details) {
        if (details == null) {
            return null;
        }
        List columnsLineage = details.getColumnsLineage();
        if (columnsLineage != null && !columnsLineage.isEmpty()) {
            for (ColumnLineage columnLineage : columnsLineage) {
                for (String fromColumn : columnLineage.getFromColumns()) {
                    this.validateChildren(fromColumn, from);
                }
                this.validateChildren(columnLineage.getToColumn(), to);
            }
        }
        return JsonUtils.pojoToJson(details);
    }

    private void validateChildren(String columnFQN, EntityReference entityReference) {
        switch (entityReference.getType()) {
            case "table": {
                Table table = (Table)Entity.getEntity("table", entityReference.getId(), "columns", Include.NON_DELETED);
                ColumnUtil.validateColumnFQN(table.getColumns(), columnFQN);
                break;
            }
            case "topic": {
                Topic topic = (Topic)Entity.getEntity("topic", entityReference.getId(), "messageSchema", Include.NON_DELETED);
                ColumnUtil.validateFieldFQN(topic.getMessageSchema().getSchemaFields(), columnFQN);
                break;
            }
            case "container": {
                Container container = (Container)Entity.getEntity("container", entityReference.getId(), "dataModel", Include.NON_DELETED);
                ColumnUtil.validateColumnFQN(container.getDataModel().getColumns(), columnFQN);
                break;
            }
            case "dashboardDataModel": {
                DashboardDataModel dashboardDataModel = (DashboardDataModel)Entity.getEntity("dashboardDataModel", entityReference.getId(), "columns", Include.NON_DELETED);
                ColumnUtil.validateColumnFQN(dashboardDataModel.getColumns(), columnFQN);
                break;
            }
            case "dashboard": {
                Dashboard dashboard = (Dashboard)Entity.getEntity("dashboard", entityReference.getId(), "charts", Include.NON_DELETED);
                dashboard.getCharts().stream().filter(c -> c.getFullyQualifiedName().equals(columnFQN)).findAny().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("chart", columnFQN)));
                break;
            }
            case "mlmodel": {
                MlModel mlModel = (MlModel)Entity.getEntity("mlmodel", entityReference.getId(), "", Include.NON_DELETED);
                mlModel.getMlFeatures().stream().filter(f -> f.getFullyQualifiedName().equals(columnFQN)).findAny().orElseThrow(() -> new IllegalArgumentException(CatalogExceptionMessage.invalidFieldName("feature", columnFQN)));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported Entity Type %s for lineage", entityReference.getType()));
            }
        }
    }

    @Transaction
    public boolean deleteLineageByFQN(String fromEntity, String fromFQN, String toEntity, String toFQN) {
        EntityReference from = Entity.getEntityReferenceByName(fromEntity, fromFQN, Include.NON_DELETED);
        EntityReference to = Entity.getEntityReferenceByName(toEntity, toFQN, Include.NON_DELETED);
        boolean result = this.dao.relationshipDAO().delete(from.getId(), from.getType(), to.getId(), to.getType(), Relationship.UPSTREAM.ordinal()) > 0;
        this.deleteLineageFromSearch(from, to);
        return result;
    }

    @Transaction
    public boolean deleteLineage(String fromEntity, String fromId, String toEntity, String toId) {
        EntityReference from = Entity.getEntityReferenceById(fromEntity, UUID.fromString(fromId), Include.NON_DELETED);
        EntityReference to = Entity.getEntityReferenceById(toEntity, UUID.fromString(toId), Include.NON_DELETED);
        boolean result = this.dao.relationshipDAO().delete(from.getId(), from.getType(), to.getId(), to.getType(), Relationship.UPSTREAM.ordinal()) > 0;
        this.deleteLineageFromSearch(from, to);
        return result;
    }

    private void deleteLineageFromSearch(EntityReference fromEntity, EntityReference toEntity) {
        searchClient.updateChildren("all", (Pair<String, String>)new ImmutablePair((Object)"lineage.doc_id.keyword", (Object)(fromEntity.getId().toString() + "-" + toEntity.getId().toString())), (Pair<String, Map<String, Object>>)new ImmutablePair((Object)String.format("for (int i = 0; i < ctx._source.lineage.length; i++) { if (ctx._source.lineage[i].doc_id == '%s') { ctx._source.lineage.remove(i) }}", fromEntity.getId().toString() + "-" + toEntity.getId().toString()), null));
    }

    private EntityLineage getLineage(EntityReference primary, int upstreamDepth, int downstreamDepth) {
        ArrayList entities = new ArrayList();
        EntityLineage lineage = new EntityLineage().withEntity(primary).withNodes(entities).withUpstreamEdges(new ArrayList()).withDownstreamEdges(new ArrayList());
        this.getUpstreamLineage(primary.getId(), primary.getType(), lineage, upstreamDepth);
        this.getDownstreamLineage(primary.getId(), primary.getType(), lineage, downstreamDepth);
        lineage.withNodes(lineage.getNodes().stream().distinct().toList());
        return lineage;
    }

    private void getUpstreamLineage(UUID id, String entityType, EntityLineage lineage, int upstreamDepth) {
        if (upstreamDepth == 0) {
            return;
        }
        List<CollectionDAO.EntityRelationshipRecord> records = entityType.equals("pipeline") || entityType.equals("storedProcedure") ? this.dao.relationshipDAO().findFromPipeline(id, Relationship.UPSTREAM.ordinal()) : this.dao.relationshipDAO().findFrom(id, entityType, Relationship.UPSTREAM.ordinal());
        ArrayList<EntityReference> upstreamEntityReferences = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            upstreamEntityReferences.add(ref);
            lineage.getUpstreamEdges().add(new Edge().withFromEntity(ref.getId()).withToEntity(id).withLineageDetails(lineageDetails));
        }
        lineage.getNodes().addAll(upstreamEntityReferences);
        --upstreamDepth;
        for (EntityReference entity : upstreamEntityReferences) {
            this.getUpstreamLineage(entity.getId(), entity.getType(), lineage, upstreamDepth);
        }
    }

    private void getDownstreamLineage(UUID id, String entityType, EntityLineage lineage, int downstreamDepth) {
        if (downstreamDepth == 0) {
            return;
        }
        List<CollectionDAO.EntityRelationshipRecord> records = entityType.equals("pipeline") || entityType.equals("storedProcedure") ? this.dao.relationshipDAO().findToPipeline(id, Relationship.UPSTREAM.ordinal()) : this.dao.relationshipDAO().findTo(id, entityType, Relationship.UPSTREAM.ordinal());
        ArrayList<EntityReference> downstreamEntityReferences = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            downstreamEntityReferences.add(ref);
            lineage.getDownstreamEdges().add(new Edge().withToEntity(ref.getId()).withFromEntity(id).withLineageDetails(lineageDetails));
        }
        lineage.getNodes().addAll(downstreamEntityReferences);
        --downstreamDepth;
        for (EntityReference entity : downstreamEntityReferences) {
            this.getDownstreamLineage(entity.getId(), entity.getType(), lineage, downstreamDepth);
        }
    }
}

