/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.teams;

import io.dropwizard.jersey.PATCH;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.teams.CreatePersona;
import org.openmetadata.schema.entity.teams.Persona;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.PersonaRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/personas")
@Tag(name="Personas", description="A `Persona` is to represent job function a user does.  OpenMetadata uses Persona to define customizable experience in the UI.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="personas", order=2)
public class PersonaResource
extends EntityResource<Persona, PersonaRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(PersonaResource.class);
    public static final String COLLECTION_PATH = "/v1/personas";
    static final String FIELDS = "users";

    @Override
    public Persona addHref(UriInfo uriInfo, Persona persona) {
        super.addHref(uriInfo, persona);
        Entity.withHref(uriInfo, persona.getUsers());
        return persona;
    }

    public PersonaResource(Authorizer authorizer) {
        super("persona", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation(FIELDS, MetadataOperation.VIEW_BASIC);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.EDIT_ALL});
    }

    @GET
    @Valid
    @Operation(operationId="listPersonas", summary="List personas", description="Get a list of personas. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of personas", content={@Content(mediaType="application/json", schema=@Schema(implementation=PersonaList.class))})})
    public ResultList<Persona> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="users")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number of personas returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of personas before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of personas after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after) {
        return super.listInternal(uriInfo, securityContext, fieldsParam, new ListFilter(null), limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllPersonaVersion", summary="List Persona versions", description="Get a list of all the versions of a persona identified by `id`", responses={@ApiResponse(responseCode="200", description="List of persona versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Persona", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Valid
    @Path(value="/{id}")
    @Operation(operationId="getPersonaByID", summary="Get a persona by id", description="Get a persona by `id`.", responses={@ApiResponse(responseCode="200", description="The Persona", content={@Content(mediaType="application/json", schema=@Schema(implementation=Persona.class))}), @ApiResponse(responseCode="404", description="Persona for instance {id} is not found")})
    public Persona get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Persona", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="users")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Persona)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Valid
    @Path(value="/name/{name}")
    @Operation(operationId="getPersonaByFQN", summary="Get a Persona by name", description="Get a Persona by `name`.", responses={@ApiResponse(responseCode="200", description="The Persona", content={@Content(mediaType="application/json", schema=@Schema(implementation=Persona.class))}), @ApiResponse(responseCode="404", description="Persona for instance {name} is not found")})
    public Persona getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the Persona", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="users")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (Persona)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificPersonaVersion", summary="Get a version of the Persona", description="Get a version of the Persona by given `id`", responses={@ApiResponse(responseCode="200", description="Persona", content={@Content(mediaType="application/json", schema=@Schema(implementation=Persona.class))}), @ApiResponse(responseCode="404", description="Persona for instance {id} and version {version} is not found")})
    public Persona getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Persona", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Personas version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (Persona)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createPersona", summary="Create a Persona", description="Create a new Persona.", responses={@ApiResponse(responseCode="200", description="The Persona.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Persona.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePersona cp) {
        Persona persona = this.getPersona(cp, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, persona);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdatePersona", summary="Update Persona", description="Create or Update a Persona.", responses={@ApiResponse(responseCode="200", description="The Persona.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Persona.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreatePersona cp) {
        Persona persona = this.getPersona(cp, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, persona);
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchPersona", summary="Update a Persona", description="Update an existing persona with JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Persona", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deletePersona", summary="Delete a Persona by id", description="Delete a Persona by given `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Persona for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Persona", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, true);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deletePersonaByName", summary="Delete a Persona by name", description="Delete a Persona by given `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Persona for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the Persona", schema=@Schema(type="string")) @PathParam(value="name") String name) {
        return this.deleteByName(uriInfo, securityContext, name, false, true);
    }

    private Persona getPersona(CreatePersona cp, String user) {
        return ((PersonaRepository)this.repository).copy(new Persona(), (CreateEntity)cp, user).withUsers(EntityUtil.toEntityReferences(cp.getUsers(), "user"));
    }

    public static class PersonaList
    extends ResultList<Persona> {
    }
}

