/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

public final class SearchIndexUtils {
    private SearchIndexUtils() {
    }

    public static List<String> parseFollowers(List<EntityReference> followersRef) {
        if (followersRef == null) {
            return Collections.emptyList();
        }
        return followersRef.stream().map(item -> item.getId().toString()).toList();
    }

    public static void removeNonIndexableFields(Map<String, Object> doc, Set<String> fields) {
        for (String key : fields) {
            if (key.contains(".")) {
                SearchIndexUtils.removeFieldByPath(doc, key);
                continue;
            }
            doc.remove(key);
        }
    }

    public static void removeFieldByPath(Map<String, Object> jsonMap, String path) {
        String[] pathElements = path.split("\\.");
        Map currentMap = jsonMap;
        for (int i = 0; i < pathElements.length - 1; ++i) {
            String key = pathElements[i];
            Object value = currentMap.get(key);
            if (!(value instanceof Map)) {
                return;
            }
            currentMap = (Map)value;
        }
        String lastKey = pathElements[pathElements.length - 1];
        currentMap.remove(lastKey);
    }

    public static List<TagLabel> parseTags(List<TagLabel> tags) {
        if (tags == null) {
            return Collections.emptyList();
        }
        return tags;
    }
}

