/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record ChartIndex(Chart chart) implements SearchIndex
{
    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.chart.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.chart.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.chart.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "chart");
        doc.put("owner", this.getEntityWithDisplayName(this.chart.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.chart.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.chart.getFollowers()));
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.chart.getVotes()) ? 0 : this.chart.getVotes().getUpVotes() - this.chart.getVotes().getDownVotes());
        return doc;
    }

    @Override
    public Object getEntity() {
        return this.chart;
    }
}

