/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record ClassificationIndex(Classification classification) implements SearchIndex
{
    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.classification.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.classification.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.classification.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "classification");
        doc.put("owner", this.getEntityWithDisplayName(this.classification.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.classification.getFollowers()));
        return doc;
    }

    @Override
    public Object getEntity() {
        return this.classification;
    }
}

