/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record DashboardServiceIndex(DashboardService dashboardService) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.dashboardService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dashboardService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dashboardService.getDisplayName()).weight(10).build());
        doc.put("fqnParts", this.getFQNParts(this.dashboardService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "dashboardService");
        doc.put("owner", this.getEntityWithDisplayName(this.dashboardService.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.dashboardService.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.dashboardService.getFollowers()));
        return doc;
    }
}

