/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.domains.DataProduct;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record DataProductIndex(DataProduct dataProduct) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.dataProduct;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dataProduct.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dataProduct.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.dataProduct.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("entityType", "dataProduct");
        doc.put("owner", this.getEntityWithDisplayName(this.dataProduct.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.dataProduct.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.dataProduct.getFollowers()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        return SearchIndex.getDefaultFields();
    }
}

