/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record DatabaseIndex(Database database) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.database;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.database.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.database.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.database.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "database");
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.database.getVotes()) ? 0 : this.database.getVotes().getUpVotes() - this.database.getVotes().getDownVotes());
        doc.put("owner", this.getEntityWithDisplayName(this.database.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.database.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.database.getFollowers()));
        return doc;
    }
}

