/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record DatabaseSchemaIndex(DatabaseSchema databaseSchema) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.databaseSchema;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.databaseSchema.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.databaseSchema.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.databaseSchema.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "databaseSchema");
        doc.put("owner", this.getEntityWithDisplayName(this.databaseSchema.getOwner()));
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.databaseSchema.getVotes()) ? 0 : this.databaseSchema.getVotes().getUpVotes() - this.databaseSchema.getVotes().getDownVotes());
        doc.put("domain", this.getEntityWithDisplayName(this.databaseSchema.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.databaseSchema.getFollowers()));
        return doc;
    }
}

