/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record DatabaseServiceIndex(DatabaseService databaseService) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.databaseService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.databaseService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.databaseService.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.databaseService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "databaseService");
        doc.put("owner", this.getEntityWithDisplayName(this.databaseService.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.databaseService.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.databaseService.getFollowers()));
        return doc;
    }
}

