/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class GlossaryIndex
implements SearchIndex {
    final Glossary glossary;

    public GlossaryIndex(Glossary glossary) {
        this.glossary = glossary;
    }

    @Override
    public Object getEntity() {
        return this.glossary;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.glossary.getName()).weight(5).build());
        if (this.glossary.getDisplayName() != null && !this.glossary.getDisplayName().isEmpty()) {
            suggest.add(SearchSuggest.builder().input(this.glossary.getDisplayName()).weight(10).build());
        }
        doc.put("fqnParts", this.getFQNParts(this.glossary.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "glossary");
        doc.put("owner", this.getEntityWithDisplayName(this.glossary.getOwner()));
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.glossary.getVotes()) ? 0 : this.glossary.getVotes().getUpVotes() - this.glossary.getVotes().getDownVotes());
        doc.put("domain", this.getEntityWithDisplayName(this.glossary.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.glossary.getFollowers()));
        return doc;
    }
}

