/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.services.MessagingService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record MessagingServiceIndex(MessagingService messagingService) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.messagingService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.messagingService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.messagingService.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.messagingService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "messagingService");
        doc.put("owner", this.getEntityWithDisplayName(this.messagingService.getOwner()));
        doc.put("domain", this.getEntityWithDisplayName(this.messagingService.getDomain()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.messagingService.getFollowers()));
        return doc;
    }
}

