/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.services.MetadataService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record MetadataServiceIndex(MetadataService metadataService) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.metadataService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.metadataService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.metadataService.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.metadataService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("suggest", suggest);
        doc.put("entityType", "metadataService");
        doc.put("owner", this.getEntityWithDisplayName(this.metadataService.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.metadataService.getFollowers()));
        return doc;
    }
}

