/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public class MlModelIndex
implements SearchIndex {
    final MlModel mlModel;

    public MlModelIndex(MlModel mlModel) {
        this.mlModel = mlModel;
    }

    @Override
    public Object getEntity() {
        return this.mlModel;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.mlModel.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.mlModel.getName()).weight(10).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("mlmodel", (EntityInterface)this.mlModel));
        doc.put("displayName", this.mlModel.getDisplayName() != null ? this.mlModel.getDisplayName() : this.mlModel.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.mlModel.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("entityType", "mlmodel");
        doc.put("serviceType", this.mlModel.getServiceType());
        doc.put("totalVotes", CommonUtil.nullOrEmpty((Object)this.mlModel.getVotes()) ? 0 : this.mlModel.getVotes().getUpVotes() - this.mlModel.getVotes().getDownVotes());
        doc.put("lineage", SearchIndex.getLineageData(this.mlModel.getEntityReference()));
        doc.put("fqnParts", this.getFQNParts(this.mlModel.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("owner", this.getEntityWithDisplayName(this.mlModel.getOwner()));
        doc.put("service", this.getEntityWithDisplayName(this.mlModel.getService()));
        doc.put("domain", this.getEntityWithDisplayName(this.mlModel.getDomain()));
        return doc;
    }

    public static Map<String, Float> getFields() {
        Map<String, Float> fields = SearchIndex.getDefaultFields();
        fields.put("mlFeatures.name", Float.valueOf(8.0f));
        fields.put("mlFeatures.description", Float.valueOf(1.0f));
        return fields;
    }
}

