/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.entity.services.PipelineService;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;

public record PipelineServiceIndex(PipelineService pipelineService) implements SearchIndex
{
    @Override
    public Object getEntity() {
        return this.pipelineService;
    }

    @Override
    public Map<String, Object> buildSearchIndexDocInternal(Map<String, Object> doc) {
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.pipelineService.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.pipelineService.getFullyQualifiedName()).weight(5).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "pipelineService");
        doc.put("fqnParts", this.getFQNParts(this.pipelineService.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).toList()));
        doc.put("owner", this.getEntityWithDisplayName(this.pipelineService.getOwner()));
        doc.put("followers", SearchIndexUtils.parseFollowers(this.pipelineService.getFollowers()));
        return doc;
    }
}

